/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.lang.reflect.provider;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Set;
import org.cp.elements.lang.JavaType;
import org.cp.elements.lang.reflect.MethodInterceptor;
import org.cp.elements.lang.reflect.ProxyFactory;
import org.cp.elements.lang.reflect.support.ComposableInvocationHandler;
import org.cp.elements.util.stream.StreamUtils;

public class JdkDynamicProxiesFactory<T>
extends ProxyFactory<T> {
    private static final Set<Class<?>> NON_PROXYABLE_TYPES = new HashSet();

    public static <T> JdkDynamicProxiesFactory<T> newJdkDynamicProxiesFactory() {
        return new JdkDynamicProxiesFactory<T>();
    }

    @Override
    public boolean canProxy(Object target, Class<?> ... proxyInterfaces) {
        return this.canProxy(target) && this.canProxy(JdkDynamicProxiesFactory.resolveInterfaces(target, proxyInterfaces));
    }

    private boolean canProxy(Object target) {
        return target == null || !JavaType.isJavaType(target);
    }

    private boolean canProxy(Class<?> ... proxyInterfaces) {
        return StreamUtils.stream(proxyInterfaces).filter(proxyInterface -> !NON_PROXYABLE_TYPES.contains(proxyInterface)).anyMatch(Class::isInterface);
    }

    @Override
    public <R> R newProxy(ClassLoader proxyClassLoader, T target, Class<?>[] proxyInterfaces, Iterable<MethodInterceptor<T>> methodInterceptors) {
        return (R)Proxy.newProxyInstance(proxyClassLoader, JdkDynamicProxiesFactory.resolveInterfaces(target, proxyInterfaces), (InvocationHandler)ComposableInvocationHandler.compose(methodInterceptors));
    }

    static {
        NON_PROXYABLE_TYPES.add(Serializable.class);
    }
}

