/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.lang.reflect.support;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.cp.elements.lang.reflect.UnhandledMethodInvocationException;
import org.cp.elements.util.ArrayUtils;

public class ComposableInvocationHandler
implements InvocationHandler,
Iterable<InvocationHandler> {
    private final List<InvocationHandler> invocationHandlers;

    @SafeVarargs
    public static <T extends InvocationHandler> ComposableInvocationHandler compose(T ... invocationHandlers) {
        return new ComposableInvocationHandler((InvocationHandler[])invocationHandlers);
    }

    public static ComposableInvocationHandler compose(Iterable<? extends InvocationHandler> invocationHandlers) {
        return new ComposableInvocationHandler(ArrayUtils.asArray(invocationHandlers, InvocationHandler.class));
    }

    protected ComposableInvocationHandler(InvocationHandler ... invocationHandlers) {
        this.invocationHandlers = Arrays.asList(ArrayUtils.nullSafeArray(invocationHandlers, InvocationHandler.class));
    }

    protected Iterable<InvocationHandler> getInvocationHandlers() {
        return Collections.unmodifiableList(this.invocationHandlers);
    }

    @Override
    public Iterator<InvocationHandler> iterator() {
        return Collections.unmodifiableList(this.invocationHandlers).iterator();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        for (InvocationHandler invocationHandler : this) {
            try {
                return invocationHandler.invoke(proxy, method, args);
            }
            catch (UnhandledMethodInvocationException unhandledMethodInvocationException) {
            }
        }
        throw new UnhandledMethodInvocationException(String.format("Method [%s] was not handled", method.getName()));
    }
}

