/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.lang.reflect.support;

import java.util.Optional;
import org.cp.elements.lang.RuntimeExceptionsFactory;
import org.cp.elements.lang.reflect.MethodInterceptor;
import org.cp.elements.lang.reflect.MethodInvocation;

public class DelegatingMethodInterceptor<T>
implements MethodInterceptor<T> {
    private MethodInterceptor<T> delegate;

    public static DelegatingMethodInterceptor newDelegatingMethodInterceptor() {
        return new DelegatingMethodInterceptor();
    }

    public static <T> DelegatingMethodInterceptor newDelegatingMethodInterceptor(MethodInterceptor<T> delegate) {
        return new DelegatingMethodInterceptor<T>(delegate);
    }

    public DelegatingMethodInterceptor() {
    }

    public DelegatingMethodInterceptor(MethodInterceptor<T> delegate) {
        this.delegate = delegate;
    }

    public synchronized void setDelegate(MethodInterceptor<T> delegate) {
        this.delegate = delegate;
    }

    protected synchronized MethodInterceptor<T> getDelegate() {
        return Optional.ofNullable(this.delegate).orElseThrow(() -> RuntimeExceptionsFactory.newIllegalStateException("The delegate MethodInterceptor was not properly initialized", new Object[0]));
    }

    @Override
    public T getTarget() {
        return this.getDelegate().getTarget();
    }

    @Override
    public <R> Optional<R> intercept(MethodInvocation methodInvocation) {
        return this.getDelegate().intercept(methodInvocation);
    }
}

