/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.lang.support;

import java.time.LocalDateTime;
import org.cp.elements.lang.Assert;
import org.cp.elements.lang.Auditable;
import org.cp.elements.lang.Visitable;
import org.cp.elements.lang.Visitor;

public class AuditableVisitor<USER, PROCESS>
implements Visitor {
    private final LocalDateTime dateTime;
    private final PROCESS process;
    private final USER user;

    public AuditableVisitor(USER user, PROCESS process) {
        this(user, process, LocalDateTime.now());
    }

    public AuditableVisitor(USER user, PROCESS process, LocalDateTime dateTime) {
        Assert.notNull(user, "User must not be null", new Object[0]);
        Assert.notNull(process, "Process must not be null", new Object[0]);
        this.user = user;
        this.process = process;
        this.dateTime = dateTime != null ? dateTime : LocalDateTime.now();
    }

    public USER getUser() {
        return this.user;
    }

    public PROCESS getProcess() {
        return this.process;
    }

    public LocalDateTime getDateTime() {
        return this.dateTime;
    }

    protected boolean isCreatedUnset(Auditable auditable) {
        return auditable.getCreatedBy() == null || auditable.getCreatedOn() == null;
    }

    @Override
    public void visit(Visitable visitable) {
        if (visitable instanceof Auditable) {
            Auditable auditable = (Auditable)((Object)visitable);
            if (auditable.isNew() || this.isCreatedUnset(auditable)) {
                auditable.setCreatedBy(this.getUser());
                auditable.setCreatedOn(this.getDateTime());
                auditable.setCreatedWith(this.getProcess());
            }
            if (auditable.isModified()) {
                auditable.setModifiedBy(this.getUser());
                auditable.setModifiedOn(this.getDateTime());
                auditable.setModifiedWith(this.getProcess());
            }
        }
    }
}

