/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.lang.support;

import org.cp.elements.lang.Composite;
import org.cp.elements.lang.Filter;
import org.cp.elements.lang.LogicalOperator;

public class ComposableFilter<T>
implements Composite<Filter<T>>,
Filter<T> {
    protected static final ComposableFilter<?> INSTANCE = new ComposableFilter();
    private final Filter<T> leftFilter;
    private final Filter<T> rightFilter;
    private final LogicalOperator op;

    public static <T> ComposableFilter<T> builder() {
        return INSTANCE;
    }

    private ComposableFilter() {
        this.leftFilter = obj -> false;
        this.rightFilter = obj -> false;
        this.op = LogicalOperator.AND;
    }

    private ComposableFilter(Filter<T> leftFilter, LogicalOperator op, Filter<T> rightFilter) {
        this.leftFilter = leftFilter;
        this.op = op;
        this.rightFilter = rightFilter;
    }

    protected static <T> Filter<T> compose(Filter<T> leftFilter, LogicalOperator op, Filter<T> rightFilter) {
        return leftFilter == null ? rightFilter : (rightFilter == null ? leftFilter : new ComposableFilter<T>(leftFilter, op, rightFilter));
    }

    public static <T> Filter<T> and(Filter<T> leftFilter, Filter<T> rightFilter) {
        return ComposableFilter.compose(leftFilter, LogicalOperator.AND, rightFilter);
    }

    public static <T> Filter<T> or(Filter<T> leftFilter, Filter<T> rightFilter) {
        return ComposableFilter.compose(leftFilter, LogicalOperator.OR, rightFilter);
    }

    public static <T> Filter<T> xor(Filter<T> leftFilter, Filter<T> rightFilter) {
        return ComposableFilter.compose(leftFilter, LogicalOperator.XOR, rightFilter);
    }

    @Override
    public Filter<T> compose(Filter<T> one, Filter<T> two) {
        return ComposableFilter.compose(one, LogicalOperator.AND, two);
    }

    protected Filter<T> getLeftFilter() {
        return this.leftFilter;
    }

    protected LogicalOperator getOp() {
        return this.op;
    }

    protected Filter<T> getRightFilter() {
        return this.rightFilter;
    }

    @Override
    public boolean accept(T obj) {
        return this.getOp().evaluate(() -> this.getLeftFilter().accept(obj), () -> this.getRightFilter().accept(obj));
    }

    public String toString() {
        return this.getClass().getName();
    }
}

