/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.lang.support;

import org.cp.elements.lang.Assert;
import org.cp.elements.lang.Composite;

public class ComposableRunnable
implements Composite<Runnable>,
Runnable {
    protected static final ComposableRunnable INSTANCE = new ComposableRunnable();
    private final Runnable leftRunnable;
    private final Runnable rightRunnable;

    public static ComposableRunnable getInstance() {
        return INSTANCE;
    }

    private ComposableRunnable() {
        this.leftRunnable = () -> {};
        this.rightRunnable = () -> {};
    }

    private ComposableRunnable(Runnable leftRunnable, Runnable rightRunnable) {
        Assert.notNull(leftRunnable, "The left Runnable object cannot be null", new Object[0]);
        Assert.notNull(rightRunnable, "The right Runnable object cannot be null", new Object[0]);
        this.leftRunnable = leftRunnable;
        this.rightRunnable = rightRunnable;
    }

    @Override
    public Runnable compose(Runnable leftRunnable, Runnable rightRunnable) {
        return leftRunnable == null ? rightRunnable : (rightRunnable == null ? leftRunnable : new ComposableRunnable(leftRunnable, rightRunnable));
    }

    @Override
    public void run() {
        this.leftRunnable.run();
        this.rightRunnable.run();
    }
}

