/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.lang.support;

import java.util.Iterator;
import org.cp.elements.lang.Transformer;
import org.cp.elements.util.ArrayUtils;
import org.cp.elements.util.CollectionUtils;

public class ComposableTransformer<T>
implements Transformer<T>,
Iterable<Transformer<T>> {
    private final Iterable<Transformer<T>> transformers;

    @SafeVarargs
    private ComposableTransformer(Transformer<T> ... transformers) {
        this.transformers = ArrayUtils.asIterable((Object[])ArrayUtils.nullSafeArray(transformers, Transformer.class).clone());
    }

    @SafeVarargs
    public static <T> Transformer<T> compose(Transformer<T> ... transformers) {
        return ArrayUtils.isEmpty(transformers) ? null : (transformers.length == 1 ? transformers[0] : new ComposableTransformer<T>(transformers));
    }

    public static <T> Transformer<T> compose(Iterable<Transformer<T>> transformers) {
        return ComposableTransformer.compose(ArrayUtils.asArray(transformers, Transformer.class));
    }

    @Override
    public Iterator<Transformer<T>> iterator() {
        return CollectionUtils.nullSafeIterable(this.transformers).iterator();
    }

    @Override
    public T transform(T value) {
        for (Transformer<T> transformer : this) {
            value = transformer.transform(value);
        }
        return value;
    }
}

