/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.lang.support;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.cp.elements.lang.Assert;
import org.cp.elements.lang.Composite;
import org.cp.elements.lang.Visitable;
import org.cp.elements.lang.Visitor;

public class ComposableVisitor
implements Composite<Visitor>,
Iterable<Visitor>,
Visitor {
    private final List<Visitor> visitors = new LinkedList<Visitor>();

    public boolean add(Visitor visitor) {
        Assert.notNull(visitor, "The Visitor to add to this composite cannot be null", new Object[0]);
        return visitor != this && !this.contains(visitor) && this.visitors.add(visitor);
    }

    @Override
    public Visitor compose(Visitor one, Visitor two) {
        if (one != null) {
            this.add(one);
        }
        if (two != null) {
            this.add(two);
        }
        return this;
    }

    public boolean contains(Visitor visitor) {
        return this.visitors.contains(visitor);
    }

    public boolean isEmpty() {
        return this.visitors.isEmpty();
    }

    @Override
    public Iterator<Visitor> iterator() {
        return Collections.unmodifiableList(this.visitors).iterator();
    }

    public boolean remove(Visitor visitor) {
        return this.visitors.remove(visitor);
    }

    public int size() {
        return this.visitors.size();
    }

    @Override
    public void visit(Visitable visitable) {
        for (Visitor visitor : this) {
            visitor.visit(visitable);
        }
    }
}

