/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.lang.support;

import java.lang.reflect.Field;
import java.util.Optional;
import java.util.logging.Logger;
import org.cp.elements.lang.Builder;
import org.cp.elements.lang.LangExtensions;
import org.cp.elements.lang.ObjectUtils;
import org.cp.elements.lang.reflect.ModifierUtils;
import org.cp.elements.lang.reflect.ReflectionUtils;
import org.cp.elements.text.FormatUtils;

public class HashCodeBuilder
implements Builder<Integer> {
    protected static final int DEFAULT_BASE_VALUE = 17;
    protected static final int DEFAULT_MULTIPLIER = 37;
    static Logger logger = Logger.getLogger(HashCodeBuilder.class.getName());
    private final int multiplier;
    private int hashValue;

    public static HashCodeBuilder create() {
        return new HashCodeBuilder();
    }

    public static HashCodeBuilder create(int baseValue, int multiplier) {
        return new HashCodeBuilder(baseValue, multiplier);
    }

    protected static Logger getLogger() {
        return logger;
    }

    public static HashCodeBuilder hashCodeFor(Object obj) {
        HashCodeBuilder builder = HashCodeBuilder.create();
        Optional.ofNullable(obj).ifPresent(object -> ReflectionUtils.withFields(new Field[0]).on(object).matching(field -> !ModifierUtils.isTransient(field)).call(field -> {
            HashCodeBuilder.getLogger().fine(() -> FormatUtils.format("Hashing field [%1$s] on object [%2$s]", field.getName(), object.getClass().getName()));
            builder.with(ReflectionUtils.getValue(object, field, field.getType()));
        }));
        return builder;
    }

    public HashCodeBuilder() {
        this(17, 37);
    }

    public HashCodeBuilder(int baseValue, int multiplier) {
        LangExtensions.assertThat(baseValue).stating("baseValue [%d] must be greater than 0", baseValue).isGreaterThan(0);
        LangExtensions.assertThat(multiplier).stating("multiplier [%d] must be greater than 0", multiplier).isGreaterThan(0);
        this.hashValue = baseValue;
        this.multiplier = multiplier;
    }

    protected HashCodeBuilder combine(int value) {
        this.setHashValue(this.multiplier() * this.hashValue() + value);
        return this;
    }

    protected int hashValue() {
        return this.hashValue;
    }

    protected HashCodeBuilder setHashValue(int hashValue) {
        this.hashValue = hashValue;
        return this;
    }

    protected int multiplier() {
        return this.multiplier;
    }

    public HashCodeBuilder with(boolean value) {
        return this.with(value ? 0 : 1);
    }

    public HashCodeBuilder with(byte value) {
        return this.with((int)value);
    }

    public HashCodeBuilder with(char value) {
        return this.with((int)value);
    }

    public HashCodeBuilder with(short value) {
        return this.with((int)value);
    }

    public HashCodeBuilder with(int value) {
        return this.combine(value);
    }

    public HashCodeBuilder with(long value) {
        return this.with((int)(value ^ value >>> 32));
    }

    public HashCodeBuilder with(float value) {
        return this.with(Float.floatToIntBits(value));
    }

    public HashCodeBuilder with(double value) {
        return this.with(Double.doubleToLongBits(value));
    }

    public HashCodeBuilder with(Object obj) {
        return this.combine(ObjectUtils.hashCode(obj));
    }

    @Override
    public Integer build() {
        return this.hashValue();
    }
}

