/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.lang.support;

import org.cp.elements.lang.Identifiable;
import org.cp.elements.lang.IdentifierSequence;
import org.cp.elements.lang.LangExtensions;
import org.cp.elements.lang.Visitable;
import org.cp.elements.lang.Visitor;
import org.cp.elements.lang.support.UUIDIdentifierSequence;

public class SetIdentityVisitor<T extends Comparable<T>>
implements Visitor {
    private final IdentifierSequence<T> identifierSequence;

    public SetIdentityVisitor() {
        this(new UUIDIdentifierSequence());
    }

    public SetIdentityVisitor(IdentifierSequence identifierSequence) {
        LangExtensions.assertThat(identifierSequence).throwing(new IllegalArgumentException("The IdentifierSequence cannot be null")).isNotNull();
        this.identifierSequence = identifierSequence;
    }

    protected IdentifierSequence<T> getIdentifierSequence() {
        return this.identifierSequence;
    }

    @Override
    public void visit(Visitable visitable) {
        if (visitable instanceof Identifiable) {
            ((Identifiable)((Object)visitable)).setId(this.getIdentifierSequence().nextId());
        }
    }
}

