/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Optional;
import org.cp.elements.lang.RuntimeExceptionsFactory;
import org.cp.elements.lang.StringUtils;
import org.cp.elements.net.NoAvailablePortException;

public abstract class NetworkUtils {
    public static int availablePort() {
        int n;
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(0);
            n = serverSocket.getLocalPort();
        }
        catch (IOException cause) {
            try {
                throw new NoAvailablePortException("No port available", cause);
            }
            catch (Throwable throwable) {
                NetworkUtils.close(serverSocket);
                throw throwable;
            }
        }
        NetworkUtils.close(serverSocket);
        return n;
    }

    public static boolean close(ServerSocket serverSocket) {
        if (serverSocket != null) {
            try {
                serverSocket.close();
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean close(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public static int lenientParsePort(String port) {
        return NetworkUtils.lenientParsePort(port, null);
    }

    public static int lenientParsePort(String port, Integer defaultPort) {
        return NetworkUtils.parsePort(StringUtils.getDigits(port), defaultPort);
    }

    public static int parsePort(String port) {
        return NetworkUtils.parsePort(port, null);
    }

    public static int parsePort(String port, Integer defaultPort) {
        try {
            return Integer.parseInt(StringUtils.trim(port));
        }
        catch (NumberFormatException cause) {
            return Optional.ofNullable(defaultPort).orElseThrow(() -> RuntimeExceptionsFactory.newIllegalArgumentException(cause, "Port [%s] is not valid", port));
        }
    }

    public static SocketAddress newSocketAddress(int port) {
        return NetworkUtils.newSocketAddress(null, port);
    }

    public static SocketAddress newSocketAddress(String host, int port) {
        return Optional.ofNullable(host).map(hostname -> new InetSocketAddress(host, port)).orElseGet(() -> new InetSocketAddress(port));
    }
}

