/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.net;

import org.cp.elements.lang.StringUtils;
import org.cp.elements.net.ServicePort;

public enum Protocol {
    FTP(ServicePort.FTP, "ftp://", "File Transfer Protocol"),
    HTTP(ServicePort.HTTP, "http://", "Hypertext Transfer Protocol"),
    HTTPS(ServicePort.HTTPS, "https://", "Secure Hypertext Transfer Protocol"),
    LDAP(ServicePort.LDAP, "ldap://", "Lightweight Directory Access Protocol"),
    SFTP(ServicePort.SFTP, "sftp://", "Secure File Transfer Protocol"),
    SMTP(ServicePort.SMTP, "smtp://", "Simple Mail Transfer Protocol");

    private final ServicePort servicePort;
    private final String description;
    private final String scheme;

    private Protocol(ServicePort servicePort, String scheme, String description) {
        this.servicePort = servicePort;
        this.scheme = scheme;
        this.description = description;
    }

    public static Protocol valueOfIgnoreCase(String name) {
        for (Protocol protocol : Protocol.values()) {
            if (!protocol.name().equalsIgnoreCase(StringUtils.trim(name))) continue;
            return protocol;
        }
        return null;
    }

    public static Protocol valueOfPortNumber(int portNumber) {
        for (Protocol protocol : Protocol.values()) {
            if (protocol.portNumber() != portNumber) continue;
            return protocol;
        }
        return null;
    }

    public static Protocol valueOfScheme(String scheme) {
        for (Protocol protocol : Protocol.values()) {
            if (!protocol.scheme().equals(StringUtils.trim(scheme))) continue;
            return protocol;
        }
        return null;
    }

    public static Protocol valueOfServicePort(ServicePort servicePort) {
        for (Protocol protocol : Protocol.values()) {
            if (!protocol.servicePort().equals((Object)servicePort)) continue;
            return protocol;
        }
        return null;
    }

    public int portNumber() {
        return this.servicePort().portNumber();
    }

    public String scheme() {
        return this.scheme;
    }

    public ServicePort servicePort() {
        return this.servicePort;
    }

    public String toString() {
        return this.description;
    }
}

