/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.net;

import org.cp.elements.lang.LangExtensions;
import org.cp.elements.lang.StringUtils;

public enum ServicePort {
    DNS(53),
    EPHEMERAL(0),
    FTP(21),
    HTTP(80),
    HTTPS(443),
    LDAP(389),
    SFTP(115),
    SMTP(25),
    SSH(22),
    TELNET(23),
    TIME(37),
    WHOIS(43);

    public static final int MIN_PORT = 0;
    public static final int MAX_PORT = 65535;
    public static final int MAX_RESERVED_PORT = 1024;
    private final int portNumber;

    private ServicePort(int portNumber) {
        LangExtensions.assertThat(portNumber).throwing(new IllegalArgumentException(String.format("port number [%s] must be greater than equal 0 and less than equal 65535", portNumber))).isGreaterThanEqualToAndLessThanEqualTo(0, 65535);
        this.portNumber = portNumber;
    }

    public static ServicePort valueOf(int portNumber) {
        for (ServicePort servicePort : ServicePort.values()) {
            if (servicePort.portNumber() != portNumber) continue;
            return servicePort;
        }
        return null;
    }

    public static ServicePort valueOfIgnoreCase(String name) {
        for (ServicePort servicePort : ServicePort.values()) {
            if (!servicePort.name().equalsIgnoreCase(StringUtils.trim(name))) continue;
            return servicePort;
        }
        return null;
    }

    public boolean isReserved() {
        return this.portNumber() <= 1024;
    }

    public int portNumber() {
        return this.portNumber;
    }
}

