/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.net.protocols.http;

import org.cp.elements.dao.CrudOperation;
import org.cp.elements.lang.ObjectUtils;
import org.cp.elements.lang.StringUtils;

public enum HttpMethod {
    POST(CrudOperation.CREATE),
    GET(CrudOperation.READ),
    PUT(CrudOperation.UPDATE),
    DELETE(CrudOperation.DELETE),
    CONNECT(null),
    HEAD(null),
    OPTIONS(null),
    TRACE(null);

    private final CrudOperation crudOperation;

    private HttpMethod(CrudOperation crudOperation) {
        this.crudOperation = crudOperation;
    }

    public static HttpMethod valueOf(CrudOperation crudOperation) {
        for (HttpMethod httpMethod : HttpMethod.values()) {
            if (!ObjectUtils.equals((Object)httpMethod.crudOperation(), (Object)crudOperation)) continue;
            return httpMethod;
        }
        return null;
    }

    public static HttpMethod valueOfIgnoreCase(String name) {
        for (HttpMethod httpMethod : HttpMethod.values()) {
            if (!httpMethod.name().equalsIgnoreCase(StringUtils.trim(name))) continue;
            return httpMethod;
        }
        return null;
    }

    public CrudOperation crudOperation() {
        return this.crudOperation;
    }
}

