/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.net.protocols.http;

import org.cp.elements.lang.RelationalOperator;
import org.cp.elements.lang.StringUtils;

public enum HttpStatus {
    CONTINUE(100, "Continue"),
    SWITCHING_PROTOCOLS(101, "Switching Protocols"),
    OK(200, "OK"),
    CREATED(201, "Created"),
    ACCEPTED(202, "Accepted"),
    NON_AUTHORITATIVE_INFORMATION(203, "Non-Authoritative Information"),
    NO_CONTENT(204, "No Content"),
    RESET_CONTENT(205, "Reset Content"),
    PARTIAL_CONTENT(206, "Partial Content"),
    MULTIPLE_CHOICES(300, "Multiple Choices"),
    MOVED_PERMANENTLY(301, "Moved Permanently"),
    FOUND(302, "Found"),
    SEE_OTHER(303, "See Other"),
    NOT_MODIFIED(304, "Not Modified"),
    USE_PROXY(305, "Use Proxy"),
    UNUSED(306, "(Unused)"),
    TEMPORARY_REDIRECT(307, "Temporary Redirect"),
    BAD_REQUEST(400, "Bad Request"),
    UNAUTHORIZED(401, "Unauthorized"),
    PAYMENT_REQUIRED(402, "Payment Required"),
    FORBIDDEN(403, "Forbidden"),
    NOT_FOUND(404, "Not Found"),
    METHOD_NOT_ALLOWED(405, "Method Not Allowed"),
    NOT_ACCEPTABLE(406, "Not Acceptable"),
    PROXY_AUTHENTICATION_REQUIRED(407, "Proxy Authentication Required"),
    REQUEST_TIMEOUT(408, "Request Timeout"),
    CONFLICT(409, "Conflict"),
    GONE(410, "Gone"),
    LENGTH_REQUIRED(411, "Length Required"),
    PRECONDITION_FAILED(412, "Precondition Failed"),
    REQUEST_ENTITY_TOO_LARGE(413, "Request Entity Too Large"),
    REQUEST_URI_TOO_LONG(414, "Request-URI Too Long"),
    UNSUPPORTED_MEDIA_TYPE(415, "Unsupported Media Type"),
    REQUESTED_RANGE_NOT_SATISFIABLE(416, "Request Range Not Satisfiable"),
    EXPECTATION_FAILED(417, "Expectation Failed"),
    INTERNAL_SERVER_ERROR(500, "Internal Server Error"),
    NOT_IMPLEMENTED(501, "Not Implemented"),
    BAD_GATEWAY(502, "Bad Gateway"),
    SERVICE_UNAVAILABLE(503, "Service Unavailable"),
    GATEWAY_TIMEOUT(504, "Gateway Timeout"),
    HTTP_VERSION_NOT_SUPPORTED(505, "HTTP Version Not Supported");

    public static final int INFORMATIONAL_HTTP_STATUS_CODE_BASE = 100;
    public static final int SUCCESSFUL_HTTP_STATUS_CODE_BASE = 200;
    public static final int REDIRECTION_HTTP_STATUS_CODE_BASE = 300;
    public static final int CLIENT_ERROR_HTTP_STATUS_CODE_BASE = 400;
    public static final int SERVER_ERROR_HTTP_STATUS_CODE_BASE = 500;
    private final int httpStatusCode;
    private final String description;

    private HttpStatus(int httpStatusCode, String description) {
        this.httpStatusCode = httpStatusCode;
        this.description = description;
    }

    public static HttpStatus valueOf(int httpStatusCode) {
        for (HttpStatus httpStatus : HttpStatus.values()) {
            if (httpStatus.code() != httpStatusCode) continue;
            return httpStatus;
        }
        return null;
    }

    public static HttpStatus valueOfDescription(String description) {
        for (HttpStatus httpStatus : HttpStatus.values()) {
            if (!httpStatus.description().equalsIgnoreCase(StringUtils.trim(description))) continue;
            return httpStatus;
        }
        return null;
    }

    boolean is(int httpStatusCodeBase) {
        return RelationalOperator.greaterThanAndLessThan(-1, 100).evaluate(this.code() - httpStatusCodeBase);
    }

    public boolean isInformational() {
        return this.is(100);
    }

    public boolean isSuccessful() {
        return this.is(200);
    }

    public boolean isRedirection() {
        return this.is(300);
    }

    public boolean isClientError() {
        return this.is(400);
    }

    public boolean isServerError() {
        return this.is(500);
    }

    public int code() {
        return this.httpStatusCode;
    }

    public String description() {
        return this.description;
    }

    public String toString() {
        return String.format("%1$d - %2$s", this.code(), this.description());
    }
}

