/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.process;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import org.cp.elements.io.FileSystemUtils;
import org.cp.elements.io.IOUtils;
import org.cp.elements.lang.Assert;
import org.cp.elements.lang.Identifiable;
import org.cp.elements.lang.Initable;
import org.cp.elements.lang.RuntimeExceptionsFactory;
import org.cp.elements.lang.SystemUtils;
import org.cp.elements.lang.concurrent.SimpleThreadFactory;
import org.cp.elements.process.PidUnknownException;
import org.cp.elements.process.ProcessContext;
import org.cp.elements.process.ProcessExecutor;
import org.cp.elements.process.event.ProcessStreamListener;
import org.cp.elements.process.support.RuntimeProcessExecutor;
import org.cp.elements.process.util.ProcessUtils;
import org.cp.elements.util.Environment;

public class ProcessAdapter
implements Identifiable<Integer>,
Initable {
    protected static final boolean DAEMON_THREAD = true;
    protected static final int THREAD_PRIORITY = 5;
    protected static final long DEFAULT_TIMEOUT_MILLISECONDS = TimeUnit.SECONDS.toMillis(30L);
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final CopyOnWriteArraySet<ProcessStreamListener> listeners = new CopyOnWriteArraySet();
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final Process process;
    private final ProcessContext processContext;
    private final ProcessStreamListener compositeProcessStreamListener = line -> this.listeners.forEach(listener -> listener.onInput(line));
    private final ThreadGroup threadGroup;

    public static ProcessAdapter newProcessAdapter(Process process) {
        return ProcessAdapter.newProcessAdapter(process, ProcessContext.newProcessContext(process).ranBy(SystemUtils.USERNAME).ranIn(FileSystemUtils.WORKING_DIRECTORY).usingEnvironmentVariables());
    }

    public static ProcessAdapter newProcessAdapter(Process process, ProcessContext processContext) {
        return new ProcessAdapter(process, processContext);
    }

    public ProcessAdapter(Process process, ProcessContext processContext) {
        Assert.notNull(process, "Process cannot be null", new Object[0]);
        Assert.notNull(processContext, "ProcessContext cannot be null", new Object[0]);
        this.process = process;
        this.processContext = processContext;
        this.threadGroup = new ThreadGroup(String.format("Process [%s] Thread Group", UUID.randomUUID()));
    }

    @Override
    public void init() {
        if (!this.getProcessContext().inheritsIO()) {
            this.newThread(String.format("Process [%d] Standard Out Reader", this.safeGetId()), this.newProcessStreamReader(this.getProcess().getInputStream())).start();
            if (!this.getProcessContext().isRedirectingErrorStream()) {
                this.newThread(String.format("Process [%d] Standard Error Reader", this.safeGetId()), this.newProcessStreamReader(this.getProcess().getErrorStream())).start();
            }
        }
        this.initialized.set(true);
    }

    protected Runnable newProcessStreamReader(InputStream in) {
        return () -> {
            if (this.isRunning()) {
                BufferedReader reader = this.newReader(in);
                try {
                    String input = reader.readLine();
                    while (input != null) {
                        this.compositeProcessStreamListener.onInput(input);
                        input = reader.readLine();
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    IOUtils.close(reader);
                }
            }
        };
    }

    protected BufferedReader newReader(InputStream in) {
        return new BufferedReader(new InputStreamReader(in));
    }

    protected Thread newThread(String name, Runnable task) {
        return SimpleThreadFactory.newThreadFactory().as(true).in(this.resolveThreadGroup()).with(5).newThread(name, task);
    }

    protected ThreadGroup resolveThreadGroup() {
        return this.threadGroup;
    }

    public Process getProcess() {
        return this.process;
    }

    public ProcessContext getProcessContext() {
        return this.processContext;
    }

    public boolean isAlive() {
        return ProcessUtils.isAlive(this.getProcess());
    }

    public boolean isNotAlive() {
        return !this.isAlive();
    }

    @Override
    public boolean isInitialized() {
        return this.initialized.get();
    }

    public boolean isRunning() {
        return ProcessUtils.isRunning(this.getProcess());
    }

    public boolean isNotRunning() {
        return !this.isRunning();
    }

    public List<String> getCommandLine() {
        return this.getProcessContext().getCommandLine();
    }

    public File getDirectory() {
        return this.getProcessContext().getDirectory();
    }

    public Environment getEnvironment() {
        return this.getProcessContext().getEnvironment();
    }

    @Override
    public Integer getId() {
        try {
            return ProcessUtils.readPid(ProcessUtils.findPidFile(this.getDirectory()));
        }
        catch (Throwable cause) {
            if (cause instanceof PidUnknownException) {
                throw (PidUnknownException)cause;
            }
            throw new PidUnknownException("Process ID (PID) cannot be determined", cause);
        }
    }

    public Integer safeGetId() {
        try {
            return this.getId();
        }
        catch (PidUnknownException ignore) {
            return -1;
        }
    }

    @Override
    public final void setId(Integer id) {
        throw RuntimeExceptionsFactory.newUnsupportedOperationException("Operation Not Supported", new Object[0]);
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public InputStream getStandardErrorStream() {
        return this.getProcess().getErrorStream();
    }

    public OutputStream getStandardInStream() {
        return this.getProcess().getOutputStream();
    }

    public InputStream getStandardOutStream() {
        return this.getProcess().getInputStream();
    }

    public String getUsername() {
        return this.getProcessContext().getUsername();
    }

    public int exitValue() {
        return this.getProcess().exitValue();
    }

    public int safeExitValue() {
        try {
            return this.exitValue();
        }
        catch (IllegalThreadStateException ignore) {
            return -1;
        }
    }

    public synchronized int kill() {
        return this.isRunning() ? ProcessAdapter.newProcessAdapter(this.getProcess().destroyForcibly(), this.getProcessContext()).waitFor() : this.safeExitValue();
    }

    public synchronized ProcessAdapter restart() {
        if (this.isRunning()) {
            this.stopAndWait();
        }
        Assert.state(this.isNotRunning(), "Process [%d] failed to stop", this.safeGetId());
        return this.execute(this, this.getProcessContext());
    }

    protected ProcessAdapter execute(ProcessAdapter processAdapter, ProcessContext processContext) {
        return this.newProcessExecutor().execute(processAdapter.getDirectory(), processAdapter.getCommandLine());
    }

    protected ProcessExecutor<ProcessAdapter> newProcessExecutor() {
        return RuntimeProcessExecutor.newRuntimeProcessExecutor();
    }

    public synchronized int stop() {
        return this.stop(DEFAULT_TIMEOUT_MILLISECONDS, TimeUnit.MILLISECONDS);
    }

    /*
     * Exception decompiling
     */
    public synchronized int stop(long timeout, TimeUnit unit) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int stopAndWait() {
        this.stop();
        return this.waitFor();
    }

    public int stopAndWait(long timeout, TimeUnit unit) {
        this.stop(timeout, unit);
        return this.waitFor(timeout, unit) ? this.exitValue() : this.safeExitValue();
    }

    public ProcessAdapter register(ProcessStreamListener listener) {
        this.listeners.add(listener);
        return this;
    }

    public ProcessAdapter registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(this.newThread(String.format("Process [%d] Runtime Shutdown Hook", this.safeGetId()), this::stop));
        return this;
    }

    public ProcessAdapter unregister(ProcessStreamListener listener) {
        this.listeners.remove(listener);
        return this;
    }

    public int waitFor() {
        try {
            return this.getProcess().waitFor();
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
            return this.safeExitValue();
        }
    }

    public boolean waitFor(long timeout, TimeUnit unit) {
        try {
            return this.getProcess().waitFor(timeout, unit);
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
            return this.isNotRunning();
        }
    }

    private /* synthetic */ Integer lambda$stop$3() throws Exception {
        this.getProcess().destroy();
        return this.getProcess().waitFor();
    }
}

