/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.process;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.cp.elements.io.FileSystemUtils;
import org.cp.elements.lang.Assert;
import org.cp.elements.lang.SystemUtils;
import org.cp.elements.util.ArrayUtils;
import org.cp.elements.util.CollectionUtils;
import org.cp.elements.util.Environment;

public class ProcessContext {
    private boolean inheritIO;
    private boolean redirectErrorStream;
    private Environment environment;
    private File directory;
    private List<String> commandLine = Collections.emptyList();
    private final Process process;
    private ProcessBuilder.Redirect error;
    private ProcessBuilder.Redirect input;
    private ProcessBuilder.Redirect output;
    private String username;

    public static ProcessContext newProcessContext(Process process) {
        return new ProcessContext(process);
    }

    protected ProcessContext(Process process) {
        Assert.notNull(process, "Process cannot be null", new Object[0]);
        this.process = process;
    }

    public List<String> getCommandLine() {
        return Collections.unmodifiableList(this.commandLine);
    }

    public File getDirectory() {
        return this.directory;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public ProcessBuilder.Redirect getError() {
        return this.error;
    }

    public ProcessBuilder.Redirect getInput() {
        return this.input;
    }

    public ProcessBuilder.Redirect getOutput() {
        return this.output;
    }

    public Process getProcess() {
        return this.process;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean inheritsIO() {
        return this.inheritIO;
    }

    public boolean isRedirectingErrorStream() {
        return this.redirectErrorStream;
    }

    public ProcessContext from(ProcessBuilder processBuilder) {
        this.ranBy(SystemUtils.USERNAME);
        this.ranIn(processBuilder.directory());
        this.ranWith(processBuilder.command());
        this.using(Environment.from(processBuilder.environment()));
        this.redirectError(processBuilder.redirectError());
        this.redirectErrorStream(processBuilder.redirectErrorStream());
        this.redirectInput(processBuilder.redirectInput());
        this.redirectOutput(processBuilder.redirectOutput());
        return this;
    }

    public ProcessContext inheritIO(boolean inheritIO) {
        this.inheritIO = inheritIO;
        return this;
    }

    public ProcessContext ranBy(String username) {
        this.username = username;
        return this;
    }

    public ProcessContext ranIn(File directory) {
        Assert.isTrue(FileSystemUtils.isDirectory(directory), "[%s] must be a valid directory", directory);
        this.directory = directory;
        return this;
    }

    public ProcessContext ranWith(String ... commandLine) {
        return this.ranWith(Arrays.asList(ArrayUtils.nullSafeArray(commandLine, String.class)));
    }

    public ProcessContext ranWith(List<String> commandLine) {
        this.commandLine = new ArrayList<String>(CollectionUtils.nullSafeList(commandLine));
        return this;
    }

    public ProcessContext redirectError(ProcessBuilder.Redirect error) {
        this.error = error;
        return this;
    }

    public ProcessContext redirectErrorStream(boolean redirectErrorStream) {
        this.redirectErrorStream = redirectErrorStream;
        return this;
    }

    public ProcessContext redirectInput(ProcessBuilder.Redirect input) {
        this.input = input;
        return this;
    }

    public ProcessContext redirectOutput(ProcessBuilder.Redirect output) {
        this.output = output;
        return this;
    }

    public ProcessContext to(ProcessBuilder processBuilder) {
        return Optional.ofNullable(processBuilder).map(localProcessBuilder -> {
            localProcessBuilder.command(this.getCommandLine());
            localProcessBuilder.directory(this.getDirectory());
            localProcessBuilder.environment().clear();
            localProcessBuilder.environment().putAll(this.getEnvironment().toMap());
            localProcessBuilder.redirectErrorStream(this.isRedirectingErrorStream());
            Optional.ofNullable(this.getError()).ifPresent(localProcessBuilder::redirectError);
            Optional.ofNullable(this.getInput()).ifPresent(localProcessBuilder::redirectInput);
            Optional.ofNullable(this.getOutput()).ifPresent(localProcessBuilder::redirectOutput);
            if (this.inheritsIO()) {
                processBuilder.inheritIO();
            }
            return this;
        }).orElse(this);
    }

    public ProcessContext using(Environment environment) {
        this.environment = environment;
        return this;
    }

    public ProcessContext usingEnvironmentVariables() {
        return this.using(Environment.fromEnvironmentVariables());
    }
}

