/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.process.java;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.cp.elements.io.FileSystemUtils;
import org.cp.elements.lang.Assert;
import org.cp.elements.lang.ClassUtils;
import org.cp.elements.lang.Executable;
import org.cp.elements.lang.ObjectUtils;
import org.cp.elements.lang.StringUtils;
import org.cp.elements.process.EmbeddedProcessExecutionException;
import org.cp.elements.process.ProcessExecutor;
import org.cp.elements.util.ArrayUtils;
import org.cp.elements.util.stream.StreamUtils;

public class EmbeddedJavaProcessExecutor
implements ProcessExecutor<Void> {
    protected static final Collection<JavaClassExecutor> JAVA_CLASS_EXECUTORS = Collections.unmodifiableList(Arrays.asList(new ExecutableExecutor(), new RunnableExecutor(), new CallableExecutor(), new MainMethodExecutor()));

    public static EmbeddedJavaProcessExecutor newEmbeddedJavaProcessExecutor() {
        return new EmbeddedJavaProcessExecutor();
    }

    @Override
    public Void execute(File directory, String ... commandLine) {
        Assert.isTrue(ObjectUtils.isNullOrEqualTo(directory, FileSystemUtils.WORKING_DIRECTORY), "The Java class can only be ran in the same working directory [%1$s] as the containing process; directory was [%2$s]", FileSystemUtils.WORKING_DIRECTORY, directory);
        Class type = this.resolveJavaClassFrom(commandLine);
        Assert.notNull(type, "The Java class to execute could not be resolved from the given command-line [%s]", Arrays.toString(commandLine));
        String[] args = this.resolveArgumentsFrom(type, commandLine);
        this.execute(type, args);
        return null;
    }

    protected String[] resolveArgumentsFrom(Class type, String ... args) {
        int index = ArrayUtils.indexOf(args, type.getName());
        int position = index + 1;
        String[] arguments = StringUtils.EMPTY_STRING_ARRAY;
        if (index != -1 && position < args.length) {
            int length = args.length - position;
            arguments = new String[length];
            System.arraycopy(args, position, arguments, 0, length);
        }
        return arguments;
    }

    protected <T> Class<T> resolveJavaClassFrom(String ... args) {
        return Arrays.stream(ArrayUtils.nullSafeArray(args, String.class)).filter(ClassUtils::isPresent).findFirst().map(ClassUtils::loadClass).orElse(null);
    }

    public <T> Optional<T> execute(Class type, String ... args) {
        Assert.notNull(type, "Class type must not be null", new Object[0]);
        return JAVA_CLASS_EXECUTORS.stream().filter(javaClassExecutor -> javaClassExecutor.isExecutable(type)).findFirst().map(javaClassExecutor -> javaClassExecutor.execute(type, args)).orElseThrow(() -> new EmbeddedProcessExecutionException(String.format("Unable to execute Java class [%s]; Please verify that your class either implements Runnable, Callable, Executable or has a main method", ClassUtils.getName(type))));
    }

    static class RunnableExecutor<T>
    implements JavaClassExecutor<T> {
        RunnableExecutor() {
        }

        @Override
        public boolean isExecutable(Class type) {
            return Runnable.class.isAssignableFrom(type);
        }

        @Override
        public Optional<T> execute(Class type, Object ... args) {
            Runnable runnable = (Runnable)this.constructInstance(type, args);
            runnable.run();
            return Optional.empty();
        }
    }

    static class MainMethodExecutor<T>
    implements JavaClassExecutor<T> {
        MainMethodExecutor() {
        }

        @Override
        public boolean isExecutable(Class type) {
            return Arrays.stream(type.getDeclaredMethods()).anyMatch(ClassUtils::isMainMethod);
        }

        @Override
        public Optional<T> execute(Class type, Object ... args) {
            try {
                Method mainMethod = type.getDeclaredMethod("main", String[].class);
                mainMethod.invoke(null, new Object[]{ArrayUtils.toStringArray(args)});
                return Optional.empty();
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new EmbeddedProcessExecutionException(String.format("Failed to execute Java class [%s] using main method", ClassUtils.getName(type)), e);
            }
        }
    }

    static class ExecutableExecutor<T>
    implements JavaClassExecutor<T> {
        ExecutableExecutor() {
        }

        @Override
        public boolean isExecutable(Class type) {
            return Executable.class.isAssignableFrom(type);
        }

        @Override
        public Optional<T> execute(Class type, Object ... args) {
            Executable executable = (Executable)this.constructInstance(type, args);
            return Optional.ofNullable(executable.execute(args));
        }
    }

    static class CallableExecutor<T>
    implements JavaClassExecutor<T> {
        CallableExecutor() {
        }

        @Override
        public boolean isExecutable(Class type) {
            return Callable.class.isAssignableFrom(type);
        }

        @Override
        public Optional<T> execute(Class type, Object ... args) {
            try {
                Callable callable = (Callable)this.constructInstance(type, args);
                return Optional.ofNullable(callable.call());
            }
            catch (Exception e) {
                throw new EmbeddedProcessExecutionException(String.format("Failed to call Java class [%s]", ClassUtils.getName(type)), e);
            }
        }
    }

    static interface JavaClassExecutor<T> {
        public boolean isExecutable(Class var1);

        public Optional<T> execute(Class var1, Object ... var2);

        default public boolean isTargetConstructor(Constructor<?> constructor) {
            return Optional.ofNullable(constructor).map(localConstructor -> ClassUtils.isDefaultConstructor(constructor) || ClassUtils.isConstructorWithArrayParameter(constructor)).orElse(false);
        }

        default public <T> Constructor<T> findConstructor(Class<T> type) {
            return StreamUtils.stream(ArrayUtils.nullSafeArray(type.getDeclaredConstructors(), Constructor.class)).filter(this::isTargetConstructor).sorted((constructorOne, constructorTwo) -> constructorTwo.getParameterCount() - constructorOne.getParameterCount()).findFirst().orElseThrow(() -> new EmbeddedProcessExecutionException(String.format("No default constructor or constructor with arguments (%1$s(:Object[]) for type [%2$s] was found", ClassUtils.getSimpleName(type), ClassUtils.getName(type))));
        }

        default public <T> T constructInstance(Class<T> type, Object[] args) {
            try {
                Constructor<T> constructor = this.findConstructor(type);
                constructor.setAccessible(true);
                return ClassUtils.isConstructorWithArrayParameter(constructor) ? constructor.newInstance(new Object[]{args}) : constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new EmbeddedProcessExecutionException(String.format("Failed to construct an instance of Java class [%s]", ClassUtils.getName(type)), e);
            }
        }
    }
}

