/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.process.java;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.cp.elements.io.FileSystemUtils;
import org.cp.elements.process.ProcessAdapter;
import org.cp.elements.process.support.RuntimeProcessExecutor;
import org.cp.elements.util.ArrayUtils;

public class JavaProcessExecutor
extends RuntimeProcessExecutor {
    public static JavaProcessExecutor newJavaProcessExecutor() {
        return new JavaProcessExecutor();
    }

    public ProcessAdapter execute(Class<?> type, String ... args) {
        return this.execute(FileSystemUtils.WORKING_DIRECTORY, type, args);
    }

    public ProcessAdapter execute(File directory, Class<?> type, String ... args) {
        return super.execute(directory, this.toJavaCommandLine(type, args));
    }

    @Override
    public ProcessAdapter execute(File jarFile, String ... args) {
        return this.execute(FileSystemUtils.WORKING_DIRECTORY, jarFile, args);
    }

    public ProcessAdapter execute(File directory, File jarFile, String ... args) {
        return super.execute(directory, this.toJavaCommandLine(jarFile, args));
    }

    protected String[] toJavaCommandLine(Class<?> type, String ... args) {
        ArrayList<String> javaCommandLine = new ArrayList<String>();
        javaCommandLine.add(FileSystemUtils.JAVA_EXE.getAbsolutePath());
        javaCommandLine.add("-server");
        javaCommandLine.add("-classpath");
        javaCommandLine.add(System.getProperty("java.class.path"));
        javaCommandLine.add(type.getName());
        javaCommandLine.addAll(Arrays.asList(ArrayUtils.nullSafeArray(args, String.class)));
        return javaCommandLine.toArray(new String[javaCommandLine.size()]);
    }

    protected String[] toJavaCommandLine(File jarFile, String ... args) {
        ArrayList<String> javaCommandLine = new ArrayList<String>();
        javaCommandLine.add(FileSystemUtils.JAVA_EXE.getAbsolutePath());
        javaCommandLine.add("-jar");
        javaCommandLine.add(FileSystemUtils.tryGetCanonicalPathElseGetAbsolutePath(jarFile));
        javaCommandLine.addAll(Arrays.asList(ArrayUtils.nullSafeArray(args, String.class)));
        return javaCommandLine.toArray(new String[javaCommandLine.size()]);
    }
}

