/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.process.support;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import org.cp.elements.io.FileUtils;
import org.cp.elements.lang.Assert;
import org.cp.elements.process.ProcessAdapter;
import org.cp.elements.process.ProcessContext;
import org.cp.elements.process.ProcessExecutionException;
import org.cp.elements.process.ProcessExecutor;
import org.cp.elements.util.Environment;

public class ProcessBuilderProcessExecutor
implements ProcessExecutor<ProcessAdapter> {
    private boolean redirectErrorStream;
    private Environment environment;
    private ProcessBuilder.Redirect error;
    private ProcessBuilder.Redirect input;
    private ProcessBuilder.Redirect output;

    public static ProcessBuilderProcessExecutor newProcessBuilderProcessExecutor() {
        return new ProcessBuilderProcessExecutor();
    }

    @Override
    public ProcessAdapter execute(File directory, String ... commandLine) {
        Assert.isTrue(FileUtils.isDirectory(directory), "[%s] is not a valid directory", directory);
        Assert.notEmpty(commandLine, "The command-line %s must contain at least 1 command", Arrays.toString(commandLine));
        try {
            Environment environment = this.getEnvironment();
            ProcessBuilder processBuilder = this.newProcessBuilder(commandLine, directory, environment);
            Process process = this.doExecute(processBuilder);
            ProcessContext processContext = ProcessContext.newProcessContext(process).from(processBuilder);
            return ProcessAdapter.newProcessAdapter(process, processContext);
        }
        catch (IOException e) {
            throw new ProcessExecutionException(String.format("Failed to execute program %1$s in directory [%2$s]", Arrays.toString(commandLine), directory), e);
        }
    }

    protected Process doExecute(ProcessBuilder processBuilder) throws IOException {
        return processBuilder.start();
    }

    protected ProcessBuilder newProcessBuilder(String[] commandLine, File directory, Environment environment) {
        ProcessBuilder processBuilder = new ProcessBuilder(commandLine);
        processBuilder.directory(directory);
        processBuilder.environment().clear();
        processBuilder.environment().putAll(environment.toMap());
        processBuilder.redirectErrorStream(this.isRedirectingErrorStream());
        this.getError().ifPresent(processBuilder::redirectError);
        this.getIn().ifPresent(processBuilder::redirectInput);
        this.getOut().ifPresent(processBuilder::redirectOutput);
        return processBuilder;
    }

    protected Environment getEnvironment() {
        return Optional.ofNullable(this.environment).orElseGet(Environment::fromEnvironmentVariables);
    }

    protected Optional<ProcessBuilder.Redirect> getError() {
        return Optional.ofNullable(this.error);
    }

    protected Optional<ProcessBuilder.Redirect> getIn() {
        return Optional.ofNullable(this.input);
    }

    protected Optional<ProcessBuilder.Redirect> getOut() {
        return Optional.ofNullable(this.output);
    }

    protected boolean isRedirectingErrorStream() {
        return this.redirectErrorStream;
    }

    public ProcessBuilderProcessExecutor redirectError(ProcessBuilder.Redirect error) {
        this.error = error;
        return this;
    }

    public ProcessBuilderProcessExecutor redirectErrorStream() {
        this.redirectErrorStream = true;
        return this;
    }

    public ProcessBuilderProcessExecutor redirectIn(ProcessBuilder.Redirect in) {
        this.input = in;
        return this;
    }

    public ProcessBuilderProcessExecutor redirectOut(ProcessBuilder.Redirect out) {
        this.output = out;
        return this;
    }

    public ProcessBuilderProcessExecutor using(Environment environment) {
        this.environment = environment;
        return this;
    }
}

