/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.process.support;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import org.cp.elements.io.FileUtils;
import org.cp.elements.lang.Assert;
import org.cp.elements.lang.SystemUtils;
import org.cp.elements.process.ProcessAdapter;
import org.cp.elements.process.ProcessContext;
import org.cp.elements.process.ProcessExecutionException;
import org.cp.elements.process.ProcessExecutor;
import org.cp.elements.util.Environment;

public class RuntimeProcessExecutor
implements ProcessExecutor<ProcessAdapter> {
    private Environment environment;

    public static RuntimeProcessExecutor newRuntimeProcessExecutor() {
        return new RuntimeProcessExecutor();
    }

    @Override
    public ProcessAdapter execute(File directory, String ... commandLine) {
        Assert.isTrue(FileUtils.isDirectory(directory), "[%s] is not a valid directory", directory);
        Assert.notEmpty(commandLine, "The command-line %s must contain at least 1 command", Arrays.toString(commandLine));
        try {
            Environment environment = this.getEnvironment();
            Process process = this.doExecute(commandLine, directory, environment);
            ProcessContext processContext = ProcessContext.newProcessContext(process).ranBy(SystemUtils.USERNAME).ranIn(directory).ranWith(commandLine).using(environment);
            return ProcessAdapter.newProcessAdapter(process, processContext);
        }
        catch (IOException e) {
            throw new ProcessExecutionException(String.format("Failed to execute program %1$s in directory [%2$s]", Arrays.toString(commandLine), directory), e);
        }
    }

    protected Process doExecute(String[] commandLine, File directory, Environment environment) throws IOException {
        return Runtime.getRuntime().exec(commandLine, environment.toAssociativeArray(), directory);
    }

    protected Environment getEnvironment() {
        return Optional.ofNullable(this.environment).orElseGet(Environment::fromEnvironmentVariables);
    }

    public RuntimeProcessExecutor using(Environment environment) {
        this.environment = environment;
        return this;
    }
}

