/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.process.util;

import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.concurrent.TimeUnit;
import org.cp.elements.io.ComposableFileFilter;
import org.cp.elements.io.DirectoriesOnlyFilter;
import org.cp.elements.io.FileExtensionFilter;
import org.cp.elements.io.FileSystemUtils;
import org.cp.elements.io.FilesOnlyFilter;
import org.cp.elements.lang.Assert;
import org.cp.elements.lang.ObjectUtils;
import org.cp.elements.lang.StringUtils;
import org.cp.elements.lang.SystemUtils;
import org.cp.elements.process.PidUnknownException;
import org.cp.elements.process.ProcessAdapter;

public abstract class ProcessUtils {
    protected static final long KILL_WAIT_TIMEOUT = 5L;
    protected static final String PROCESS_ID_FILENAME = ".pid";
    protected static final String WINDOWS_KILL_COMMAND = "taskkill /F /PID";
    protected static final String UNIX_KILL_COMMAND = "kill -KILL";
    protected static final String VIRTUAL_MACHINE_CLASS_NAME = "com.sun.tools.attach.VirtualMachine";
    protected static final FileFilter PID_FILE_FILTER = ComposableFileFilter.and(FilesOnlyFilter.INSTANCE, new FileExtensionFilter(".pid"));
    protected static final FileFilter DIRECTORY_PID_FILE_FILTER = ComposableFileFilter.or(DirectoriesOnlyFilter.INSTANCE, PID_FILE_FILTER);
    protected static final TimeUnit KILL_WAIT_TIME_UNIT = TimeUnit.SECONDS;

    public static int getProcessId() {
        int atSignIndex;
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        String runtimeMxBeanName = runtimeMxBean.getName();
        NumberFormatException cause = null;
        if (StringUtils.hasText(runtimeMxBeanName) && (atSignIndex = runtimeMxBeanName.indexOf(64)) > 0) {
            try {
                return Integer.parseInt(runtimeMxBeanName.substring(0, atSignIndex));
            }
            catch (NumberFormatException e) {
                cause = e;
            }
        }
        throw new PidUnknownException(String.format("Process ID (PID) unknown [%s]", runtimeMxBeanName), cause);
    }

    public static boolean isAlive(Process process) {
        return process != null && process.isAlive();
    }

    public static boolean isRunning(int processId) {
        return VirtualMachineAccessor.INSTANCE.isRunning(processId);
    }

    public static boolean isRunning(Process process) {
        try {
            return process != null && (double)process.exitValue() == Double.NaN;
        }
        catch (IllegalThreadStateException ignore) {
            return true;
        }
    }

    public static boolean isRunning(ProcessAdapter processAdapter) {
        return processAdapter != null && ProcessUtils.isRunning(processAdapter.getProcess());
    }

    public static boolean kill(int processId) {
        String killCommand = String.format("%s %d", SystemUtils.isWindows() ? WINDOWS_KILL_COMMAND : UNIX_KILL_COMMAND, processId);
        try {
            Process killProcess = Runtime.getRuntime().exec(killCommand);
            return killProcess.waitFor(5L, KILL_WAIT_TIME_UNIT);
        }
        catch (Throwable ignore) {
            return false;
        }
    }

    /*
     * Loose catch block
     */
    public static boolean kill(Process process) {
        boolean alive;
        block12: {
            alive = ProcessUtils.isAlive(process);
            if (alive) {
                process.destroy();
                boolean bl = alive = !process.waitFor(5L, KILL_WAIT_TIME_UNIT);
                if (!alive) break block12;
                process.destroyForcibly();
                try {
                    alive = !process.waitFor(5L, KILL_WAIT_TIME_UNIT);
                }
                catch (InterruptedException ignore) {
                    Thread.currentThread().interrupt();
                }
                break block12;
                catch (InterruptedException ignore) {
                    try {
                        Thread.currentThread().interrupt();
                        if (!alive) break block12;
                        process.destroyForcibly();
                    }
                    catch (Throwable throwable) {
                        if (alive) {
                            process.destroyForcibly();
                            try {
                                alive = !process.waitFor(5L, KILL_WAIT_TIME_UNIT);
                            }
                            catch (InterruptedException ignore2) {
                                Thread.currentThread().interrupt();
                            }
                        }
                        throw throwable;
                    }
                    try {
                        alive = !process.waitFor(5L, KILL_WAIT_TIME_UNIT);
                    }
                    catch (InterruptedException ignore3) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
        return !alive || !ProcessUtils.isAlive(process);
    }

    public static boolean kill(ProcessAdapter processAdapter) {
        return processAdapter != null && ProcessUtils.kill(processAdapter.getProcess());
    }

    protected static Thread newThread(Runnable runnable) {
        return new Thread(runnable, "Process Shutdown Hook Thread");
    }

    public static void registerShutdownHook(int processId) {
        Runtime.getRuntime().addShutdownHook(ProcessUtils.newThread(() -> ProcessUtils.kill(processId)));
    }

    public static void registerShutdownHook(Process process) {
        Runtime.getRuntime().addShutdownHook(ProcessUtils.newThread(() -> ProcessUtils.kill(process)));
    }

    public static void registerShutdownHook(ProcessAdapter processAdapter) {
        ProcessUtils.registerShutdownHook(processAdapter.getProcess());
    }

    public static File findPidFile(File path) {
        Assert.isTrue(FileSystemUtils.isExisting(path), "The path [%s] to search for the .pid file must not be null and must actually exist", path);
        File searchDirectory = path.isDirectory() ? path : path.getParentFile();
        for (File file : searchDirectory.listFiles(DIRECTORY_PID_FILE_FILTER)) {
            if (file.isDirectory()) {
                file = ProcessUtils.findPidFile(file);
            }
            if (!PID_FILE_FILTER.accept(file)) continue;
            return file;
        }
        return null;
    }

    public static int readPid(File pid) {
        try {
            return Integer.parseInt(FileSystemUtils.read(pid));
        }
        catch (IOException | IllegalArgumentException | IllegalStateException e) {
            throw new PidUnknownException(String.format("Failed to read Process ID (PID) from file [%s]", pid), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File writePid(int pid) throws IOException {
        File pidFile = FileSystemUtils.newFile(PROCESS_ID_FILENAME);
        pidFile.deleteOnExit();
        PrintWriter writer = ProcessUtils.newPrintWriter(pidFile);
        try {
            writer.print(pid);
            writer.flush();
            File file = pidFile;
            return file;
        }
        finally {
            FileSystemUtils.close(writer);
        }
    }

    private static PrintWriter newPrintWriter(File file) throws IOException {
        return new PrintWriter((Writer)new BufferedWriter(new FileWriter(file, false), 32), true);
    }

    static enum VirtualMachineAccessor {
        INSTANCE;


        public boolean isRunning(int processId) {
            return ObjectUtils.isPresent(ProcessUtils.VIRTUAL_MACHINE_CLASS_NAME) && this.doIsRunning(processId);
        }

        protected boolean doIsRunning(int processId) {
            for (VirtualMachineDescriptor vmDescriptor : VirtualMachine.list()) {
                if (!String.valueOf(processId).equals(vmDescriptor.id())) continue;
                return true;
            }
            return false;
        }
    }
}

