/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.service.support;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.cp.elements.data.caching.Cache;
import org.cp.elements.data.caching.provider.ConcurrentMapCache;
import org.cp.elements.data.caching.support.CachingTemplate;

public class AbstractCacheableService<KEY extends Comparable<KEY>, VALUE> {
    private final AtomicBoolean cacheMiss = new AtomicBoolean(false);
    private final Cache<KEY, VALUE> cache = this.newCache();

    protected Optional<Cache<KEY, VALUE>> getCache() {
        return Optional.ofNullable(this.cache);
    }

    protected Cache<KEY, VALUE> newCache() {
        return new ConcurrentMapCache();
    }

    protected boolean isCachingEnabled() {
        return this.getCache().isPresent();
    }

    public boolean isCacheHit() {
        return !this.isCacheMiss();
    }

    public boolean isCacheMiss() {
        return this.cacheMiss.getAndSet(false);
    }

    protected boolean setCacheMiss() {
        return this.cacheMiss.compareAndSet(false, true);
    }

    protected VALUE withCaching(KEY key, Supplier<VALUE> cacheLoader) {
        return (VALUE)this.getCache().map(CachingTemplate::with).map(template -> template.withCaching(key, () -> this.lambda$null$0((Supplier)cacheLoader))).orElseGet(cacheLoader);
    }

    private /* synthetic */ Object lambda$null$0(Supplier cacheLoader) {
        this.setCacheMiss();
        return cacheLoader.get();
    }
}

