/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.tools.io;

import java.io.File;
import java.util.Arrays;
import java.util.Optional;
import org.cp.elements.io.FileSystemUtils;
import org.cp.elements.lang.RuntimeExceptionsFactory;
import org.cp.elements.lang.StringUtils;
import org.cp.elements.util.ArrayUtils;

public class ListFiles
implements Runnable {
    protected static final File DEFAULT_DIRECTORY = FileSystemUtils.WORKING_DIRECTORY;
    protected static final String DIRECTORY_MARKER = "+++";
    protected static final String DIRECTORY_MARKER_WITH_DIRECTORY_NAME = "+++ %s";
    protected static final String DIRECTORY_SWIM_LANE = "|";
    protected static final String FILE_MARKER = "---";
    protected static final String FILE_MARKER_WITH_FILENAME = "--- %s";
    protected static final String SUB_DIRECTORY_DASH_PLUS_OFFSET = "- ";
    protected static final String SUB_DIRECTORY_OFFSET = "  ";
    private final File directory;

    public static void main(String[] args) {
        ListFiles.newListFiles(ListFiles.resolveDirectory(args)).run();
    }

    static String resolveArgument(String[] args) {
        return Optional.ofNullable(args).map(ArrayUtils::getFirst).filter(StringUtils::hasText).orElseThrow(() -> RuntimeExceptionsFactory.newIllegalArgumentException("Directory is required", new Object[0]));
    }

    static File resolveDirectory(String[] args) {
        return Optional.of(ListFiles.resolveArgument(args)).map(File::new).filter(File::isDirectory).orElseThrow(() -> RuntimeExceptionsFactory.newIllegalArgumentException("Argument [%s] is not a valid directory", args[0]));
    }

    public static ListFiles newListFiles() {
        return ListFiles.newListFiles(DEFAULT_DIRECTORY);
    }

    public static ListFiles newListFiles(File directory) {
        return new ListFiles(directory);
    }

    public ListFiles(File directory) {
        this.directory = this.validateDirectory(directory);
    }

    protected File getDirectory() {
        return Optional.ofNullable(this.directory).orElseGet(() -> DEFAULT_DIRECTORY);
    }

    @Override
    public void run() {
        this.listFiles(this.printHeader(this.getDirectory()), "");
    }

    public void listFiles(File directory, String indent) {
        directory = this.validateDirectory(directory);
        indent = Optional.ofNullable(indent).filter(StringUtils::hasText).orElse("");
        this.printDirectoryName(indent, directory);
        String directoryContentIndent = this.buildDirectoryContentIndent(indent);
        Arrays.stream(this.sort(ArrayUtils.nullSafeArray(directory.listFiles(), File.class))).forEach(file -> {
            if (FileSystemUtils.isDirectory(file)) {
                this.listFiles((File)file, directoryContentIndent);
            } else {
                this.printFileName(directoryContentIndent, (File)file);
            }
        });
    }

    String buildDirectoryContentIndent(String indent) {
        return Optional.ofNullable(indent).filter(StringUtils::hasText).map(it -> it + " " + SUB_DIRECTORY_OFFSET + DIRECTORY_SWIM_LANE).orElseGet(() -> " |");
    }

    String concatIndentAndDirectoryName(String indent, File directory) {
        indent = Optional.ofNullable(indent).filter(StringUtils::hasText).map(it -> it + SUB_DIRECTORY_DASH_PLUS_OFFSET).orElse("");
        return String.format(indent + DIRECTORY_MARKER_WITH_DIRECTORY_NAME, directory.getName());
    }

    String concatIndentAndFileName(String indent, File file) {
        return String.format(indent + SUB_DIRECTORY_OFFSET + FILE_MARKER_WITH_FILENAME, file.getName());
    }

    private File printDirectoryName(String indent, File directory) {
        System.out.printf(String.format("%s%n", this.concatIndentAndDirectoryName(indent, directory)), new Object[0]);
        return directory;
    }

    private File printFileName(String indent, File file) {
        System.out.printf(String.format("%s%n", this.concatIndentAndFileName(indent, file)), new Object[0]);
        return file;
    }

    File printHeader(File directory) {
        System.out.printf("Listing contents for directory [%s]...%n%n", directory.getAbsolutePath());
        return directory;
    }

    protected File[] sort(File[] files) {
        Arrays.sort(files, (fileOne, fileTwo) -> {
            if (fileOne.isDirectory() && fileTwo.isDirectory()) {
                return fileOne.getName().compareTo(fileTwo.getName());
            }
            if (fileOne.isDirectory()) {
                return -1;
            }
            if (fileTwo.isDirectory()) {
                return 1;
            }
            return fileOne.getName().compareTo(fileTwo.getName());
        });
        return files;
    }

    private File validateDirectory(File directory) {
        return Optional.ofNullable(directory).filter(File::isDirectory).orElseThrow(() -> RuntimeExceptionsFactory.newIllegalArgumentException("File [%s] is not a valid directory", directory));
    }
}

