/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.tools.net;

import java.io.IOException;
import java.net.Socket;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.cp.elements.lang.Condition;
import org.cp.elements.lang.LangExtensions;
import org.cp.elements.lang.NumberUtils;
import org.cp.elements.lang.RuntimeExceptionsFactory;
import org.cp.elements.net.NetworkUtils;
import org.cp.elements.test.Tester;

public class ConnectionTester
implements Condition,
Tester {
    protected static final boolean SO_REUSEADDR = true;
    protected static final long CONNECT_TIMEOUT = TimeUnit.SECONDS.toMillis(1L);
    protected static final String HOST_PORT_SEPARATOR = ":";
    private final AtomicBoolean connected = new AtomicBoolean(false);
    private final String host;
    private final int port;

    public static void main(String[] args) {
        Arrays.stream(args).forEach(hostPort -> {
            String[] hostPortSplit = hostPort.split(HOST_PORT_SEPARATOR);
            String host = hostPortSplit.length > 1 ? hostPortSplit[0] : null;
            int port = NetworkUtils.lenientParsePort(hostPortSplit.length > 1 ? hostPortSplit[1] : hostPortSplit[0]);
            System.out.printf("Connection to [%1$s:%2$d] was %3$ssuccessful%n", Optional.ofNullable(host).orElse("localhost"), port, ConnectionTester.newConnectionTester(host, port).test() ? "" : "not ");
        });
    }

    public static ConnectionTester newConnectionTester(int port) {
        return new ConnectionTester(null, port);
    }

    public static ConnectionTester newConnectionTester(String host, int port) {
        return new ConnectionTester(host, port);
    }

    public ConnectionTester(String host, int port) {
        LangExtensions.assertThat(port).throwing(RuntimeExceptionsFactory.newIllegalArgumentException("[%d] is not a valid port number", port)).isGreaterThanAndLessThanEqualTo(0, 65535);
        this.host = host == null || host.trim().isEmpty() ? null : host;
        this.port = port;
    }

    public boolean isConnected() {
        return this.connected.get();
    }

    public boolean isNotConnected() {
        return !this.isConnected();
    }

    protected ConnectionTester setConnected(boolean connected) {
        this.connected.set(connected);
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public boolean evaluate() {
        return this.test();
    }

    public boolean retest() {
        return this.setConnected(false).test();
    }

    @Override
    public boolean test() {
        if (this.isNotConnected()) {
            Socket socket = null;
            try {
                socket = this.newSocket();
                socket.setReuseAddress(true);
                socket.connect(NetworkUtils.newSocketAddress(this.getHost(), this.getPort()), NumberUtils.intValue(CONNECT_TIMEOUT));
                this.setConnected(socket.isConnected());
            }
            catch (IOException iOException) {
            }
            finally {
                NetworkUtils.close(socket);
            }
        }
        return this.isConnected();
    }

    protected Socket newSocket() {
        return new Socket();
    }
}

