/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.tools.net;

import java.io.IOException;
import java.net.Socket;
import org.cp.elements.lang.LangExtensions;
import org.cp.elements.lang.RuntimeExceptionsFactory;
import org.cp.elements.lang.ThrowableUtils;
import org.cp.elements.net.NetworkUtils;
import org.cp.elements.tools.net.support.AbstractClientServerSupport;
import org.cp.elements.util.ArrayUtils;

public class EchoClient
extends AbstractClientServerSupport {
    protected static final String DEFAULT_HOST = null;
    private final int port;
    private final String host;

    public static void main(String[] args) {
        EchoClient.validateArguments(args);
        EchoClient echoClient = EchoClient.newEchoClient(NetworkUtils.lenientParsePort(args[0]));
        for (int index = 1; index < args.length; ++index) {
            System.out.println(echoClient.sendMessage(args[index]));
        }
    }

    private static void validateArguments(String[] args) {
        if (ArrayUtils.isEmpty(args)) {
            System.err.printf("$ java ... %s <port> [<message1> <message2> ... <messageN>]%n", EchoClient.class.getName());
            System.exit(1);
        }
    }

    public static EchoClient newEchoClient(int port) {
        return new EchoClient(DEFAULT_HOST, port);
    }

    public static EchoClient newEchoClient(String host, int port) {
        return new EchoClient(host, port);
    }

    public EchoClient(int port) {
        this(DEFAULT_HOST, port);
    }

    public EchoClient(String host, int port) {
        LangExtensions.assertThat(port).throwing(RuntimeExceptionsFactory.newIllegalArgumentException("Port [%d] must be greater than 0 and less than equal to 65535", port)).isGreaterThanAndLessThanEqualTo(0, 65535);
        this.host = host;
        this.port = port;
    }

    protected String getHost() {
        return this.host;
    }

    protected int getPort() {
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendMessage(String message) {
        String string;
        Socket socket = null;
        try {
            socket = this.newSocket(this.getHost(), this.getPort());
            string = this.receiveResponse(this.sendMessage(socket, message));
        }
        catch (Throwable throwable) {
            NetworkUtils.close(socket);
            throw throwable;
        }
        NetworkUtils.close(socket);
        return string;
    }

    @Override
    protected Socket sendMessage(Socket socket, String message) {
        try {
            return super.sendMessage(socket, message);
        }
        catch (IOException e) {
            this.getLogger().severe(String.format("Failed to send message [%1$s] to EchoServer [%2$s]", message, socket.getRemoteSocketAddress()));
            this.getLogger().severe(ThrowableUtils.getStackTrace(e));
            return socket;
        }
    }

    protected String receiveResponse(Socket socket) {
        try {
            return super.receiveMessage(socket);
        }
        catch (IOException e) {
            this.getLogger().severe(String.format("Failed to receive response from EchoServer [%s]", socket.getRemoteSocketAddress()));
            this.getLogger().severe(ThrowableUtils.getStackTrace(e));
            return "No Reply";
        }
    }
}

