/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.tools.net;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.cp.elements.lang.LangExtensions;
import org.cp.elements.lang.RuntimeExceptionsFactory;
import org.cp.elements.lang.ThrowableUtils;
import org.cp.elements.lang.concurrent.ThreadUtils;
import org.cp.elements.net.NetworkUtils;
import org.cp.elements.tools.net.support.AbstractClientServerSupport;
import org.cp.elements.util.ArrayUtils;

public class EchoServer
extends AbstractClientServerSupport
implements Runnable {
    protected static final int EXECUTOR_THREAD_POOL_SIZE = 10;
    protected static final long DEFAULT_DURATION_MILLISECONDS = TimeUnit.SECONDS.toMillis(15L);
    private final int port;
    private ExecutorService echoService;
    private final ServerSocket serverSocket;

    public static void main(String[] args) {
        EchoServer.validateArguments(args);
        EchoServer.newEchoServer(NetworkUtils.lenientParsePort(args[0])).run();
    }

    private static void validateArguments(String[] args) {
        if (ArrayUtils.isEmpty(args)) {
            System.err.printf("$ java -server ... %s <port>%n", EchoServer.class.getName());
            System.exit(1);
        }
    }

    public static EchoServer newEchoServer(int port) {
        return new EchoServer(port);
    }

    public EchoServer(int port) {
        LangExtensions.assertThat(port).throwing(RuntimeExceptionsFactory.newIllegalArgumentException("Port [%d] must be greater than 1024 and less than equal to 65535", port)).isGreaterThanAndLessThanEqualTo(1024, 65535);
        this.port = port;
        this.serverSocket = this.newServerSocket(port);
        Runtime.getRuntime().addShutdownHook(new Thread(this::shutdown));
    }

    public boolean isNotRunning() {
        return !this.isRunning();
    }

    public boolean isRunning() {
        return this.isRunning(this.getServerSocket());
    }

    protected ExecutorService getEchoService() {
        return this.echoService;
    }

    public int getPort() {
        return this.port;
    }

    protected ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    @Override
    public void run() {
        this.getLogger().info(() -> String.format("Starting EchoServer on port [%d]...", this.getPort()));
        this.runEchoService(this.getServerSocket());
    }

    public EchoServer runAndWaitFor() {
        return this.runAndWaitFor(DEFAULT_DURATION_MILLISECONDS);
    }

    public EchoServer runAndWaitFor(long duration) {
        this.run();
        this.waitFor(duration);
        return this;
    }

    protected void runEchoService(ServerSocket serverSocket) {
        if (this.isRunning(serverSocket)) {
            this.echoService = this.newExecutorService();
            this.echoService.submit(() -> {
                block3: {
                    try {
                        while (this.isRunning(serverSocket)) {
                            Socket echoClient = serverSocket.accept();
                            this.getLogger().info(() -> String.format("EchoClient connected from [%s]", echoClient.getRemoteSocketAddress()));
                            this.echoService.submit(() -> {
                                this.sendResponse(echoClient, this.receiveMessage(echoClient));
                                NetworkUtils.close(echoClient);
                            });
                        }
                    }
                    catch (IOException cause) {
                        if (!this.isRunning(serverSocket)) break block3;
                        this.getLogger().warning(() -> String.format("An IO error occurred while listening for EchoClients:%n%s", ThrowableUtils.getStackTrace(cause)));
                    }
                }
            });
            this.getLogger().info(() -> String.format("EchoServer running on port [%d]", this.getPort()));
        }
    }

    protected ExecutorService newExecutorService() {
        return Executors.newFixedThreadPool(10);
    }

    @Override
    protected String receiveMessage(Socket socket) {
        try {
            String message = super.receiveMessage(socket);
            this.getLogger().fine(() -> String.format("Received message [%1$s] from EchoClient [%2$s]", message, socket.getRemoteSocketAddress()));
            return message;
        }
        catch (IOException cause) {
            this.getLogger().warning(() -> String.format("Failed to receive message from EchoClient [%s]", socket.getRemoteSocketAddress()));
            this.getLogger().fine(() -> ThrowableUtils.getStackTrace(cause));
            return "What?";
        }
    }

    protected void sendResponse(Socket socket, String message) {
        try {
            this.getLogger().info(() -> String.format("Sending response [%1$s] to EchoClient [%2$s]", message, socket.getRemoteSocketAddress()));
            this.sendMessage(socket, message);
        }
        catch (IOException cause) {
            this.getLogger().warning(() -> String.format("Failed to send response [%1$s] to EchoClient [%2$s]", message, socket.getRemoteSocketAddress()));
            this.getLogger().fine(() -> ThrowableUtils.getStackTrace(cause));
        }
    }

    public void shutdown() {
        this.getLogger().info("Stopping EchoServer...");
        this.closeServerSocket();
        this.stopEchoService();
        this.getLogger().info("EchoServer stopped");
    }

    protected void closeServerSocket() {
        ServerSocket serverSocket = this.getServerSocket();
        if (!NetworkUtils.close(serverSocket)) {
            this.getLogger().warning(() -> String.format("Failed to close ServerSocket bound to address [%s], listening on port [%d]", serverSocket.getInetAddress(), serverSocket.getLocalPort()));
        }
    }

    protected boolean stopEchoService() {
        return Optional.ofNullable(this.getEchoService()).map(localEchoService -> {
            localEchoService.shutdown();
            try {
                if (!localEchoService.awaitTermination(30L, TimeUnit.SECONDS)) {
                    localEchoService.shutdownNow();
                    if (!localEchoService.awaitTermination(30L, TimeUnit.SECONDS)) {
                        this.getLogger().warning("Failed to shutdown EchoService");
                    }
                }
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
            return localEchoService.isShutdown();
        }).orElse(false);
    }

    public boolean waitFor() {
        return this.waitFor(DEFAULT_DURATION_MILLISECONDS);
    }

    public boolean waitFor(long duration) {
        return ThreadUtils.waitFor(duration).checkEvery(500L).on(this::isRunning);
    }
}

