/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.tools.net.support;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.cp.elements.lang.NumberUtils;
import org.cp.elements.lang.RuntimeExceptionsFactory;
import org.cp.elements.net.NetworkUtils;

public abstract class AbstractClientServerSupport {
    public static final boolean DEFAULT_REUSE_ADDRESS = true;
    public static final long DEFAULT_SO_TIMEOUT = TimeUnit.SECONDS.toMillis(15L);
    protected Logger logger = Logger.getLogger(this.getClass().getName());

    protected boolean isRunning(ServerSocket serverSocket) {
        return Optional.ofNullable(serverSocket).map(localServerSocket -> !localServerSocket.isClosed() && localServerSocket.isBound()).orElse(false);
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected BufferedReader newBufferedReader(Socket socket) throws IOException {
        return new BufferedReader(new InputStreamReader(socket.getInputStream()));
    }

    protected PrintWriter newPrintWriter(Socket socket) throws IOException {
        return new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(socket.getOutputStream())), true);
    }

    public ServerSocket newServerSocket(int port) {
        try {
            ServerSocket serverSocket = this.newServerSocket();
            serverSocket.setReuseAddress(true);
            serverSocket.bind(NetworkUtils.newSocketAddress(port));
            return serverSocket;
        }
        catch (IOException cause) {
            throw RuntimeExceptionsFactory.newRuntimeException(cause, "Failed to create a ServerSocket on port [%d]", port);
        }
    }

    protected ServerSocket newServerSocket() throws IOException {
        return new ServerSocket();
    }

    public Socket newSocket(String host, int port) {
        try {
            Socket socket = this.newSocket();
            socket.setReuseAddress(true);
            socket.setSoTimeout(NumberUtils.intValue(DEFAULT_SO_TIMEOUT));
            socket.connect(NetworkUtils.newSocketAddress(host, port));
            return socket;
        }
        catch (IOException cause) {
            throw RuntimeExceptionsFactory.newRuntimeException(cause, "Failed to create a client Socket on host [%s] and port [%d]", host, port);
        }
    }

    protected Socket newSocket() {
        return new Socket();
    }

    protected String receiveMessage(Socket socket) throws IOException {
        return this.newBufferedReader(socket).readLine();
    }

    protected Socket sendMessage(Socket socket, String message) throws IOException {
        PrintWriter printWriter = this.newPrintWriter(socket);
        printWriter.println(message);
        printWriter.flush();
        return socket;
    }
}

