/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.stream.Collectors;
import org.cp.elements.lang.Assert;
import org.cp.elements.lang.Filter;
import org.cp.elements.lang.FilteringTransformer;
import org.cp.elements.lang.LangExtensions;
import org.cp.elements.lang.ObjectUtils;
import org.cp.elements.lang.Transformer;
import org.cp.elements.util.CollectionUtils;

public abstract class ArrayUtils {
    private static final Object[] EMPTY_ARRAY = new Object[0];

    public static <T> T[] append(T element, T[] array) {
        return ArrayUtils.insert(element, array, ArrayUtils.count(array));
    }

    @SafeVarargs
    public static <T> T[] asArray(T ... elements) {
        return elements;
    }

    public static <T> T[] asArray(Enumeration<T> enumeration, Class<T> componentType) {
        return ArrayUtils.asArray(CollectionUtils.asIterable(enumeration), componentType);
    }

    public static <T> T[] asArray(Iterable<T> iterable, Class<T> componentType) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T element : CollectionUtils.nullSafeIterable(iterable)) {
            arrayList.add(element);
        }
        return arrayList.toArray((Object[])Array.newInstance(ObjectUtils.defaultIfNull(componentType, Object.class), arrayList.size()));
    }

    public static <T> T[] asArray(Iterator<T> iterator, Class<T> componentType) {
        return ArrayUtils.asArray(CollectionUtils.asIterable(iterator), componentType);
    }

    @SafeVarargs
    public static <T> Enumeration<T> asEnumeration(final T ... array) {
        return array == null ? Collections.emptyEnumeration() : new Enumeration<T>(){
            private int index = 0;

            @Override
            public boolean hasMoreElements() {
                return this.index < array.length;
            }

            @Override
            public T nextElement() {
                Assert.isTrue(this.hasMoreElements(), new NoSuchElementException("No more elements"));
                return array[this.index++];
            }
        };
    }

    @SafeVarargs
    public static <T> Iterable<T> asIterable(T ... array) {
        return () -> ArrayUtils.asIterator(array);
    }

    @SafeVarargs
    public static <T> Iterator<T> asIterator(final T ... array) {
        return array == null ? Collections.emptyIterator() : new Iterator<T>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < array.length;
            }

            @Override
            public T next() {
                Assert.isTrue(this.hasNext(), new NoSuchElementException("No more elements"));
                return array[this.index++];
            }
        };
    }

    public static <T> int count(T[] array) {
        return array != null ? array.length : 0;
    }

    public static <T> long count(T[] array, Filter<T> filter) {
        Assert.notNull(filter, "Filter is required", new Object[0]);
        return Arrays.stream(ArrayUtils.nullSafeArray(array)).filter(filter::accept).count();
    }

    public static <T> T[] defaultIfEmpty(T[] array, T[] defaultArray) {
        return ArrayUtils.isNotEmpty(array) ? array : defaultArray;
    }

    public static Object[] emptyArray() {
        return (Object[])EMPTY_ARRAY.clone();
    }

    public static <T> T[] filter(T[] array, Filter<T> filter) {
        Assert.notNull(array, "Array is required", new Object[0]);
        Assert.notNull(filter, "Filter is required", new Object[0]);
        List<Object> arrayList = Arrays.stream(array).filter(filter::accept).collect(Collectors.toList());
        return arrayList.toArray((Object[])Array.newInstance(array.getClass().getComponentType(), arrayList.size()));
    }

    public static <T> T[] filterAndTransform(T[] array, FilteringTransformer<T> filteringTransformer) {
        return ArrayUtils.transform(ArrayUtils.filter(array, filteringTransformer), filteringTransformer);
    }

    public static <T> List<T> findAll(T[] array, Filter<T> filter) {
        Assert.notNull(filter, "Filter is required", new Object[0]);
        return Arrays.stream(ArrayUtils.nullSafeArray(array)).filter(filter::accept).collect(Collectors.toList());
    }

    public static <T> T findOne(T[] array, Filter<T> filter) {
        Assert.notNull(filter, "Filter is required", new Object[0]);
        return Arrays.stream(ArrayUtils.nullSafeArray(array)).filter(filter::accept).findFirst().orElse(null);
    }

    public static <T> T getElementAt(T[] array, int index) {
        return ArrayUtils.getElementAt(array, index, null);
    }

    public static <T> T getElementAt(T[] array, int index, T defaultValue) {
        return ArrayUtils.nullSafeLength(array) > index ? array[index] : defaultValue;
    }

    @SafeVarargs
    public static <T> T getFirst(T ... array) {
        return ArrayUtils.getFirst(array, null);
    }

    public static <T> T getFirst(T[] array, T defaultValue) {
        return ArrayUtils.getElementAt(array, 0, defaultValue);
    }

    @SafeVarargs
    public static <T> T getLast(T ... array) {
        return ArrayUtils.getLast(array, null);
    }

    public static <T> T getLast(T[] array, T defaultValue) {
        return ArrayUtils.getElementAt(array, Math.max(0, ArrayUtils.nullSafeLength(array) - 1), defaultValue);
    }

    public static <T> int indexOf(T[] array, T element) {
        int length = ArrayUtils.nullSafeLength(array);
        for (int index = 0; index < length; ++index) {
            if (!ObjectUtils.equalsIgnoreNull(array[index], element)) continue;
            return index;
        }
        return -1;
    }

    public static <T> T[] insert(T element, T[] array, int index) {
        Assert.notNull(array, "Array is required", new Object[0]);
        LangExtensions.assertThat(index).throwing(new ArrayIndexOutOfBoundsException(String.format("[%1$d] is not a valid index [0, %2$d] in the array", index, array.length))).isGreaterThanEqualToAndLessThanEqualTo(0, array.length);
        Class componentType = array.getClass().getComponentType();
        componentType = ObjectUtils.defaultIfNull(componentType, ObjectUtils.getClass(element));
        componentType = ObjectUtils.defaultIfNull(componentType, Object.class);
        Object[] newArray = (Object[])Array.newInstance(componentType, array.length + 1);
        if (index > 0) {
            System.arraycopy(array, 0, newArray, 0, index);
        }
        newArray[index] = element;
        if (index < array.length) {
            System.arraycopy(array, index, newArray, index + 1, array.length - index);
        }
        return newArray;
    }

    public static boolean isEmpty(Object[] array) {
        return ArrayUtils.count(array) == 0;
    }

    public static boolean isNotEmpty(Object[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static boolean isSizeOne(Object ... array) {
        return array != null && array.length == 1;
    }

    public static <T> T[] nullSafeArray(T[] array) {
        return ArrayUtils.nullSafeArray(array, ArrayUtils.componentType(array));
    }

    public static <T> T[] nullSafeArray(T[] array, Class<?> componentType) {
        return array != null ? array : (Object[])Array.newInstance(ObjectUtils.defaultIfNull(componentType, Object.class), 0);
    }

    static <T> Class<?> componentType(T[] array) {
        return array != null ? array.getClass().getComponentType() : Object.class;
    }

    public static <T> int nullSafeLength(T[] array) {
        return ArrayUtils.count(array);
    }

    public static <T> T[] prepend(T element, T[] array) {
        return ArrayUtils.insert(element, array, 0);
    }

    public static <T> T[] remove(T[] array, int index) {
        Assert.notNull(array, "Array is required", new Object[0]);
        LangExtensions.assertThat(index).throwing(new ArrayIndexOutOfBoundsException(String.format("[%1$d] is not a valid index [0, %2$d] in the array", index, array.length))).isGreaterThanEqualToAndLessThan(0, array.length);
        Class componentType = ObjectUtils.defaultIfNull(array.getClass().getComponentType(), Object.class);
        Object[] newArray = (Object[])Array.newInstance(componentType, array.length - 1);
        if (index > 0) {
            System.arraycopy(array, 0, newArray, 0, index);
        }
        if (index + 1 < array.length) {
            System.arraycopy(array, index + 1, newArray, index, array.length - index - 1);
        }
        return newArray;
    }

    public static <T> T[] shuffle(T[] array) {
        if (ArrayUtils.isNotEmpty(array)) {
            Random random = new Random(System.currentTimeMillis());
            int lengthMinusOne = array.length - 1;
            for (int index = 0; index < lengthMinusOne; ++index) {
                int randomIndex = random.nextInt(lengthMinusOne - index) + 1;
                ArrayUtils.swap(array, index, index + randomIndex);
            }
        }
        return array;
    }

    public static <T extends Comparable<T>> T[] sort(T[] array) {
        return (Comparable[])ArrayUtils.sort(array, Comparable::compareTo);
    }

    public static <T> T[] sort(T[] array, Comparator<T> comparator) {
        Arrays.sort(array, comparator);
        return array;
    }

    public static <T> T[] subArray(T[] array, int ... indices) {
        ArrayList<T> subArrayList = new ArrayList<T>(indices.length);
        for (int index : indices) {
            subArrayList.add(array[index]);
        }
        return subArrayList.toArray((Object[])Array.newInstance(array.getClass().getComponentType(), subArrayList.size()));
    }

    public static <T> T[] swap(T[] array, int indexOne, int indexTwo) {
        T elementAtIndexOne = array[indexOne];
        array[indexOne] = array[indexTwo];
        array[indexTwo] = elementAtIndexOne;
        return array;
    }

    public static String[] toStringArray(Object ... array) {
        String[] stringArray = new String[ArrayUtils.nullSafeLength(array)];
        int index = 0;
        for (Object element : ArrayUtils.nullSafeArray(array)) {
            stringArray[index++] = String.valueOf(element);
        }
        return stringArray;
    }

    public static <T> T[] transform(T[] array, Transformer<T> transformer) {
        Assert.notNull(array, "Array is required", new Object[0]);
        Assert.notNull(transformer, "Transformer is required", new Object[0]);
        for (int index = 0; index < array.length; ++index) {
            array[index] = transformer.transform(array[index]);
        }
        return array;
    }
}

