/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.util;

import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.cp.elements.lang.Assert;
import org.cp.elements.util.CollectionUtils;

public class BreadthFirstIterator<T>
implements Iterator<T> {
    private AtomicBoolean nextCalled = new AtomicBoolean(false);
    private final Deque<Iterator<T>> iterators = new LinkedList<Iterator<T>>();

    public BreadthFirstIterator(Iterator<Iterator<T>> iterators) {
        Assert.notNull(iterators, "The Iterator of Iterators must not be null!", new Object[0]);
        for (Iterator<T> iterator : CollectionUtils.asIterable(iterators)) {
            if (iterator == null) continue;
            this.iterators.add(iterator);
        }
    }

    @Override
    public boolean hasNext() {
        while (!this.iterators.isEmpty() && !this.iterators.peek().hasNext()) {
            Assert.isFalse(this.iterators.removeFirst().hasNext(), new IllegalStateException("removing a non-empty Iterator"));
        }
        return !this.iterators.isEmpty() && this.iterators.peek().hasNext();
    }

    @Override
    public T next() {
        Assert.isTrue(this.hasNext(), new NoSuchElementException("The iteration has no more elements!"));
        T value = this.iterators.peek().next();
        this.nextCalled.set(true);
        return value;
    }

    @Override
    public void remove() {
        Assert.state(this.nextCalled.compareAndSet(true, false), "next was not called before remove", new Object[0]);
        this.iterators.peek().remove();
    }
}

