/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cp.elements.lang.FluentApiExtension;
import org.cp.elements.lang.annotation.FluentApi;

public class CollectionExtensions {
    @FluentApi
    @SafeVarargs
    public static <T> From<T> from(T ... array) {
        return new FromExpression<T>(array);
    }

    private static final class FromExpression<T>
    implements From<T> {
        private final T[] array;

        @SafeVarargs
        public FromExpression(T ... array) {
            this.array = array;
        }

        @Override
        public List<T> toList() {
            return this.array == null ? Collections.emptyList() : (this.array.length == 1 ? Collections.singletonList(this.array[0]) : Arrays.asList(this.array));
        }

        @Override
        public Set<T> toSet() {
            return this.array == null ? Collections.emptySet() : (this.array.length == 1 ? Collections.singleton(this.array[0]) : new HashSet<T>(this.toList()));
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder("[");
            if (this.array != null) {
                for (int index = 0; index < this.array.length; ++index) {
                    buffer.append(index > 0 ? ", " : "");
                    buffer.append(this.array[index]);
                }
            }
            return buffer.append("]").toString();
        }
    }

    public static interface From<T>
    extends FluentApiExtension {
        public List<T> toList();

        public Set<T> toSet();
    }
}

