/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.cp.elements.lang.Assert;
import org.cp.elements.lang.Filter;
import org.cp.elements.lang.FilteringTransformer;
import org.cp.elements.lang.Renderer;
import org.cp.elements.lang.Transformer;
import org.cp.elements.lang.support.ToStringRenderer;
import org.cp.elements.util.ArrayUtils;

public abstract class CollectionUtils {
    public static <E, T extends Collection<E>> T addAll(T collection, Iterable<E> iterable) {
        Assert.notNull(collection, "Collection is required", new Object[0]);
        for (E element : CollectionUtils.nullSafeIterable(iterable)) {
            collection.add(element);
        }
        return collection;
    }

    public static <T> Enumeration<T> asEnumeration(final Iterator<T> iterator) {
        return iterator == null ? Collections.emptyEnumeration() : new Enumeration<T>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public T nextElement() {
                return iterator.next();
            }
        };
    }

    public static <T> Iterable<T> asIterable(Enumeration<T> enumeration) {
        return () -> CollectionUtils.asIterator(enumeration);
    }

    public static <T> Iterable<T> asIterable(Iterator<T> iterator) {
        return () -> CollectionUtils.nullSafeIterator(iterator);
    }

    public static <T> Iterator<T> asIterator(final Enumeration<T> enumeration) {
        return enumeration == null ? Collections.emptyIterator() : new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @Override
            public T next() {
                return enumeration.nextElement();
            }
        };
    }

    public static <T> List<T> asList(Iterable<T> iterable) {
        return iterable instanceof Collection ? new ArrayList((Collection)iterable) : StreamSupport.stream(CollectionUtils.nullSafeIterable(iterable).spliterator(), false).collect(Collectors.toList());
    }

    @SafeVarargs
    public static <T> Set<T> asSet(T ... elements) {
        return Arrays.stream(ArrayUtils.nullSafeArray(elements)).collect(Collectors.toSet());
    }

    public static <T> Set<T> asSet(Iterable<T> iterable) {
        return iterable instanceof Collection ? new HashSet((Collection)iterable) : StreamSupport.stream(CollectionUtils.nullSafeIterable(iterable).spliterator(), false).collect(Collectors.toSet());
    }

    public static boolean containsAny(Collection<?> collection, Object ... elements) {
        for (Object element : ArrayUtils.nullSafeArray(elements)) {
            if (!CollectionUtils.nullSafeCollection(collection).contains(element)) continue;
            return true;
        }
        return false;
    }

    public static long count(Iterable<?> iterable) {
        return iterable instanceof Collection ? (long)((Collection)iterable).size() : CollectionUtils.count(iterable, element -> true);
    }

    public static <T> long count(Iterable<T> iterable, Filter<T> filter) {
        Assert.notNull(filter, "Filter is required", new Object[0]);
        return StreamSupport.stream(CollectionUtils.nullSafeIterable(iterable).spliterator(), false).filter(filter::accept).count();
    }

    public static <E, T extends Iterable<E>> T defaultIfEmpty(T iterable, T defaultIterable) {
        return iterable != null && iterable.iterator().hasNext() ? iterable : defaultIterable;
    }

    public static <T> Iterable<T> emptyIterable() {
        return Collections::emptyIterator;
    }

    public static <T> Collection<T> filter(Collection<T> collection, Filter<T> filter) {
        Assert.notNull(collection, "Collection is required", new Object[0]);
        Assert.notNull(filter, "Filter is required", new Object[0]);
        return collection.stream().filter(filter::accept).collect(Collectors.toList());
    }

    public static <T> Collection<T> filterAndTransform(Collection<T> collection, FilteringTransformer<T> filteringTransformer) {
        Assert.notNull(collection, "Collection is required", new Object[0]);
        Assert.notNull(filteringTransformer, "FilteringTransformer is required", new Object[0]);
        return collection.stream().filter(filteringTransformer::accept).map(filteringTransformer::transform).collect(Collectors.toList());
    }

    public static <T> List<T> findAll(Iterable<T> iterable, Filter<T> filter) {
        Assert.notNull(filter, "Filter is required", new Object[0]);
        return StreamSupport.stream(CollectionUtils.nullSafeIterable(iterable).spliterator(), false).filter(filter::accept).collect(Collectors.toList());
    }

    public static <T> T findOne(Iterable<T> iterable, Filter<T> filter) {
        Assert.notNull(filter, "Filter is required", new Object[0]);
        return StreamSupport.stream(CollectionUtils.nullSafeIterable(iterable).spliterator(), false).filter(filter::accept).findFirst().orElse(null);
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        return iterable == null || !iterable.iterator().hasNext();
    }

    public static boolean isNotEmpty(Iterable<?> iterable) {
        return !CollectionUtils.isEmpty(iterable);
    }

    public static boolean isSizeOne(Collection<?> collection) {
        return CollectionUtils.nullSafeSize(collection) == 1;
    }

    public static <T> Collection<T> nullSafeCollection(Collection<T> collection) {
        return collection != null ? collection : Collections.emptyList();
    }

    public static <T> Enumeration<T> nullSafeEnumeration(Enumeration<T> enumeration) {
        return enumeration != null ? enumeration : Collections.emptyEnumeration();
    }

    public static <T> Iterable<T> nullSafeIterable(Iterable<T> iterable) {
        return iterable != null ? iterable : CollectionUtils.emptyIterable();
    }

    public static <T> Iterator<T> nullSafeIterator(Iterator<T> iterator) {
        return iterator != null ? iterator : Collections.emptyIterator();
    }

    public static <T> List<T> nullSafeList(List<T> list) {
        return list != null ? list : Collections.emptyList();
    }

    public static <T> Set<T> nullSafeSet(Set<T> set) {
        return set != null ? set : Collections.emptySet();
    }

    public static int nullSafeSize(Collection<?> collection) {
        return collection != null ? collection.size() : 0;
    }

    public static <T> List<T> shuffle(List<T> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            Random random = new Random(System.currentTimeMillis());
            int sizeMinusOne = CollectionUtils.nullSafeSize(list) - 1;
            for (int index = 0; index < sizeMinusOne; ++index) {
                int randomIndex = random.nextInt(sizeMinusOne - index) + 1;
                Collections.swap(list, index, index + randomIndex);
            }
        }
        return list;
    }

    public static <T> List<T> subList(List<T> list, int ... indices) {
        Assert.notNull(list, "List is required", new Object[0]);
        Assert.notNull(indices, "Indices is required", new Object[0]);
        ArrayList<T> subList = new ArrayList<T>(indices.length);
        for (int index : indices) {
            subList.add(list.get(index));
        }
        return subList;
    }

    public static <T> T[] toArray(Collection<T> collection, Class<T> componentType) {
        Object[] array = (Object[])Array.newInstance(componentType, CollectionUtils.nullSafeSize(collection));
        Optional.ofNullable(collection).ifPresent(localCollection -> collection.toArray(array));
        return array;
    }

    public static String toString(Iterable<?> iterable) {
        return CollectionUtils.toString(iterable, new ToStringRenderer());
    }

    public static <T> String toString(Iterable<T> iterable, Renderer<T> renderer) {
        StringBuilder buffer = new StringBuilder("[");
        int count = 0;
        for (T element : CollectionUtils.nullSafeIterable(iterable)) {
            buffer.append(count++ > 0 ? ", " : "").append(renderer.render(element));
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static <T> Collection<T> transform(Collection<T> collection, Transformer<T> transformer) {
        Assert.notNull(collection, "Collection is required", new Object[0]);
        Assert.notNull(transformer, "Transformer is required", new Object[0]);
        return collection.stream().map(transformer::transform).collect(Collectors.toList());
    }

    public static <T> Iterator<T> unmodifiableIterator(final Iterator<T> iterator) {
        Assert.notNull(iterator, "Iterator is required", new Object[0]);
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return iterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Iterator is immutable");
            }
        };
    }
}

