/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.util;

import java.util.Comparator;

public abstract class ComparatorUtils {
    public static <T extends Comparable<T>> int compareIgnoreNull(T obj1, T obj2) {
        return obj1 == null ? 1 : (obj2 == null ? -1 : obj1.compareTo(obj2));
    }

    public static <T> Comparator<T> invert(Comparator<T> comparator) {
        return (obj1, obj2) -> -1 * comparator.compare(obj1, obj2);
    }

    public static <T> Comparator<T> nullSafeArgumentsComparator(Comparator<T> delegate) {
        return (obj1, obj2) -> obj1 == null ? 1 : (obj2 == null ? -1 : delegate.compare(obj1, obj2));
    }

    public static <T extends Comparable<T>> Comparator<T> nullSafeComparator(Comparator<T> comparator) {
        return comparator != null ? comparator : ComparatorUtils::compareIgnoreNull;
    }
}

