/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.cp.elements.lang.Assert;
import org.cp.elements.util.CollectionUtils;

public class DepthFirstIterator<T>
implements Iterator<T> {
    private final AtomicBoolean nextCalled = new AtomicBoolean(false);
    private final List<Iterator<T>> iteratorList = new ArrayList<Iterator<T>>();
    private int currentIteratorIndex = 0;

    public DepthFirstIterator(Iterator<Iterator<T>> iterators) {
        Assert.notNull(iterators, "The Iterator of Iterators must not be null!", new Object[0]);
        for (Iterator<T> iterator : CollectionUtils.asIterable(iterators)) {
            if (iterator == null) continue;
            this.iteratorList.add(iterator);
        }
    }

    @Override
    public boolean hasNext() {
        while (!this.iteratorList.isEmpty() && !this.iteratorList.get(this.currentIteratorIndex).hasNext()) {
            Assert.isFalse(this.iteratorList.remove(this.currentIteratorIndex).hasNext(), "removing a non-empty Iterator", new Object[0]);
            this.currentIteratorIndex = this.iteratorList.isEmpty() ? 0 : this.currentIteratorIndex % this.iteratorList.size();
        }
        return !this.iteratorList.isEmpty();
    }

    @Override
    public T next() {
        Assert.isTrue(this.hasNext(), new NoSuchElementException("The iteration has no more elements!"));
        T nextValue = this.iteratorList.get(this.currentIteratorIndex).next();
        ++this.currentIteratorIndex;
        this.currentIteratorIndex %= this.iteratorList.size();
        this.nextCalled.set(true);
        return nextValue;
    }

    @Override
    public void remove() {
        Assert.state(this.nextCalled.compareAndSet(true, false), "next was not called before remove", new Object[0]);
        int iteratorIndexForRemove = this.currentIteratorIndex - 1;
        iteratorIndexForRemove = iteratorIndexForRemove < 0 ? this.iteratorList.size() - 1 : iteratorIndexForRemove;
        this.iteratorList.get(iteratorIndexForRemove).remove();
    }
}

