/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.util;

import java.io.File;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.cp.elements.io.FileSystemUtils;
import org.cp.elements.lang.Assert;
import org.cp.elements.lang.Version;
import org.cp.elements.util.MapUtils;
import org.cp.elements.util.PropertiesAdapter;
import org.cp.elements.util.PropertiesBuilder;

public class Environment
implements Iterable<String> {
    protected static final String JAVA_CLASS_PATH = "java.class.path";
    protected static final String JAVA_HOME = "java.home";
    protected static final String JAVA_LIBRARY_PATH = "java.library.path";
    protected static final String JAVA_VENDOR = "java.vendor";
    protected static final String JAVA_VERSION = "java.version";
    protected static final String JVM_NAME = "java.vm.name";
    protected static final String JVM_VENDOR = "java.vm.vendor";
    protected static final String JVM_VERSION = "java.vm.version";
    protected static final String OS_ARCHITECTURE = "os.arch";
    protected static final String OS_NAME = "os.name";
    protected static final String OS_VERSION = "os.version";
    protected static final String PATH = "PATH";
    protected static final String USER_DIRECTORY = "user.dir";
    protected static final String USER_HOME = "user.home";
    protected static final String USER_NAME = "user.name";
    private final PropertiesAdapter environmentVariables;
    private final PropertiesAdapter systemProperties;

    public static Environment from(String[] associativeArray) {
        return Environment.from(MapUtils.fromAssociativeArray(associativeArray));
    }

    public static Environment from(Map<String, String> map) {
        return new Environment(PropertiesBuilder.from(map).buildPropertiesAdapter());
    }

    public static Environment from(Properties properties) {
        return new Environment(PropertiesAdapter.from(properties));
    }

    public static Environment fromEnvironmentVariables() {
        return new Environment(PropertiesBuilder.fromEnvironmentVariables().buildPropertiesAdapter());
    }

    protected Environment(PropertiesAdapter environmentVariables) {
        Assert.notNull(environmentVariables, "The initial environment cannot be null", new Object[0]);
        this.environmentVariables = environmentVariables;
        this.systemProperties = PropertiesBuilder.fromSystemProperties().buildPropertiesAdapter();
    }

    protected PropertiesAdapter environmentVariables() {
        return this.environmentVariables;
    }

    protected PropertiesAdapter systemProperties() {
        return this.systemProperties;
    }

    public boolean isEmpty() {
        return this.environmentVariables().isEmpty();
    }

    public boolean isSet(String environmentVariableName) {
        return this.environmentVariables().isSet(environmentVariableName);
    }

    public Map<String, String> copyTo(Map<String, String> map) {
        map.putAll(this.environmentVariables().toMap());
        return map;
    }

    public Properties copyTo(Properties properties) {
        properties.putAll(this.environmentVariables().toMap());
        return properties;
    }

    public String get(String environmentVariableName) {
        return this.environmentVariables().get(environmentVariableName);
    }

    public String get(String environmentVariableName, String defaultValue) {
        return this.environmentVariables().get(environmentVariableName, defaultValue);
    }

    public <T> T getAs(String environmentVariableName, Class<T> type) {
        return this.environmentVariables().getAsType(environmentVariableName, type);
    }

    public <T> T getAs(String environmentVariableName, Class<T> type, T defaultValue) {
        return this.environmentVariables().getAsType(environmentVariableName, type, defaultValue);
    }

    public String getJavaClassPath() {
        return this.systemProperties().get(JAVA_CLASS_PATH);
    }

    public File getJavaHome() {
        return FileSystemUtils.newFile(this.systemProperties().get(JAVA_HOME));
    }

    public String getJavaLibraryPath() {
        return this.systemProperties().get(JAVA_LIBRARY_PATH);
    }

    public String getJavaVendor() {
        return this.systemProperties().get(JAVA_VENDOR);
    }

    public Version getJavaVersion() {
        return Version.parse(this.systemProperties().get(JAVA_VERSION));
    }

    public String getJvmName() {
        return this.systemProperties().get(JVM_NAME);
    }

    public String getJvmVendor() {
        return this.systemProperties().get(JVM_VENDOR);
    }

    public Version getJvmVersion() {
        return Version.parse(this.systemProperties().get(JVM_VERSION));
    }

    public String getOperatingSystemArchitecture() {
        return this.systemProperties().get(OS_ARCHITECTURE);
    }

    public String getOperatingSystemName() {
        return this.systemProperties().get(OS_NAME);
    }

    public Version getOperatingSystemVersion() {
        return Version.parse(this.systemProperties().get(OS_VERSION));
    }

    public String getSystemPath() {
        return this.environmentVariables().get(PATH);
    }

    public File getUserDirectory() {
        return FileSystemUtils.newFile(this.systemProperties().get(USER_DIRECTORY));
    }

    public File getUserHome() {
        return FileSystemUtils.newFile(this.systemProperties().get(USER_HOME));
    }

    public String getUserName() {
        return this.systemProperties().get(USER_NAME);
    }

    @Override
    public Iterator<String> iterator() {
        return this.environmentVariables().iterator();
    }

    public int size() {
        return this.environmentVariables().size();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Environment)) {
            return false;
        }
        Environment that = (Environment)obj;
        return this.environmentVariables().equals(that.environmentVariables());
    }

    public int hashCode() {
        int hashValue = 17;
        hashValue = 37 * hashValue + this.environmentVariables().hashCode();
        return hashValue;
    }

    public String toString() {
        return this.environmentVariables().toString();
    }

    public String[] toAssociativeArray() {
        return MapUtils.toAssociativeArray(this.toMap());
    }

    public Map<String, String> toMap() {
        return this.environmentVariables().toMap();
    }

    public Properties toProperties() {
        return this.environmentVariables().getProperties();
    }
}

