/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.util;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.cp.elements.lang.Assert;

public class MapBuilder<KEY, VALUE> {
    private final Map<KEY, VALUE> map;

    public static <KEY, VALUE> MapBuilder<KEY, VALUE> newConcurrentMap() {
        return new MapBuilder(new ConcurrentHashMap());
    }

    public static <KEY, VALUE> MapBuilder<KEY, VALUE> newHashMap() {
        return new MapBuilder(new HashMap());
    }

    public static <KEY, VALUE> MapBuilder<KEY, VALUE> newSortedMap() {
        return new MapBuilder(new TreeMap());
    }

    protected MapBuilder(Map<KEY, VALUE> map) {
        Assert.notNull(map, "Map is required", new Object[0]);
        this.map = map;
    }

    protected Map<KEY, VALUE> getMap() {
        return this.map;
    }

    public MapBuilder<KEY, VALUE> put(KEY key, VALUE value) {
        this.getMap().put(key, value);
        return this;
    }

    public MapBuilder<KEY, VALUE> putAll(Map<KEY, VALUE> map) {
        this.getMap().putAll(map);
        return this;
    }

    public MapBuilder<KEY, VALUE> putIfAbsent(KEY key, VALUE value) {
        this.getMap().putIfAbsent(key, value);
        return this;
    }

    public <T extends Map<KEY, VALUE>> T build() {
        return (T)this.getMap();
    }
}

