/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.cp.elements.lang.Assert;
import org.cp.elements.lang.Filter;
import org.cp.elements.lang.FilteringTransformer;
import org.cp.elements.lang.StringUtils;
import org.cp.elements.lang.Transformer;
import org.cp.elements.util.ArrayUtils;

public abstract class MapUtils {
    public static <K, V> int count(Map<K, V> map) {
        return map != null ? map.size() : 0;
    }

    public static <K, V> long count(Map<K, V> map, Filter<Map.Entry<K, V>> filter) {
        Assert.notNull(filter, "Filter is required", new Object[0]);
        return MapUtils.nullSafeMap(map).entrySet().stream().filter(filter::accept).count();
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map, Filter<Map.Entry<K, V>> filter) {
        Assert.notNull(map, "Map is required", new Object[0]);
        Assert.notNull(filter, "Filter is required", new Object[0]);
        return map.entrySet().stream().filter(filter::accept).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static <K, V> Map<K, V> filterAndTransform(Map<K, V> map, FilteringTransformer<Map.Entry<K, V>> filteringTransformer) {
        Assert.notNull(map, "Map is required", new Object[0]);
        Assert.notNull(filteringTransformer, "FilteringTransformer is required", new Object[0]);
        return map.entrySet().stream().filter(filteringTransformer::accept).map(filteringTransformer::transform).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static <K, V> Map<K, V> findAll(Map<K, V> map, Filter<Map.Entry<K, V>> filter) {
        return MapUtils.filter(map, filter);
    }

    public static Map<String, String> fromAssociativeArray(String[] associativeArray) {
        HashMap<String, String> map = new HashMap<String, String>(ArrayUtils.nullSafeLength(associativeArray));
        int index = 0;
        for (String element : ArrayUtils.nullSafeArray(associativeArray, String.class)) {
            Assert.hasText(element, "Entry [%s] at index [%d] must be specified", element, index);
            String[] entry = element.split("=");
            Assert.isTrue(entry.length == 2, "Entry [%s] at index [%d] must have both a key and a value", element, index);
            String key = StringUtils.trim(entry[0]);
            String value = StringUtils.trim(entry[1]);
            map.put(key, value);
            ++index;
        }
        return map;
    }

    public static boolean isEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmpty(Map map) {
        return !MapUtils.isEmpty(map);
    }

    public static boolean isSizeOne(Map<?, ?> map) {
        return MapUtils.size(map) == 1;
    }

    public static <K, V> Map.Entry<K, V> newMapEntry(final K key, final V value) {
        return new Map.Entry<K, V>(){

            @Override
            public K getKey() {
                return key;
            }

            @Override
            public V getValue() {
                return value;
            }

            @Override
            public V setValue(V value2) {
                throw new UnsupportedOperationException("Operation Not Supported");
            }
        };
    }

    public static <K, V> Map<K, V> nullSafeMap(Map<K, V> map) {
        return map != null ? map : Collections.emptyMap();
    }

    public static int size(Map<?, ?> map) {
        return MapUtils.count(map);
    }

    public static String[] toAssociativeArray(Map<?, ?> map) {
        ArrayList<String> list = new ArrayList<String>(MapUtils.size(map));
        for (Map.Entry<?, ?> entry : MapUtils.nullSafeMap(map).entrySet()) {
            list.add(String.format("%1$s=%2$s", String.valueOf(entry.getKey()), entry.getValue()));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String toString(Map<?, ?> map) {
        StringBuilder builder = new StringBuilder("[");
        int count = 0;
        map = new TreeMap(MapUtils.nullSafeMap(map));
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            builder.append("\n\t");
            builder.append(entry.getKey());
            builder.append(" = ");
            builder.append(entry.getValue());
            builder.append(++count == map.size() ? "\n" : ",");
        }
        builder.append("]");
        return builder.toString();
    }

    public static <K, V> Map<K, V> transform(Map<K, V> map, Transformer<V> transformer) {
        Assert.notNull(map, "Map is required", new Object[0]);
        Assert.notNull(transformer, "Transformer is required", new Object[0]);
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> transformer.transform(entry.getValue())));
    }
}

