/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import org.cp.elements.data.conversion.ConversionService;
import org.cp.elements.lang.Assert;
import org.cp.elements.lang.Filter;
import org.cp.elements.lang.StringUtils;
import org.cp.elements.util.MapUtils;

public class PropertiesAdapter
implements Iterable<String> {
    private final ConversionService conversionService;
    private final Properties delegate;

    public static PropertiesAdapter from(Properties properties) {
        return new PropertiesAdapter(properties);
    }

    public PropertiesAdapter(Properties properties) {
        Assert.notNull(properties, "The Properties to wrap cannot be null", new Object[0]);
        this.delegate = properties;
        this.conversionService = ServiceLoader.load(ConversionService.class).iterator().next();
    }

    protected ConversionService getConversionService() {
        return this.conversionService;
    }

    protected Properties getProperties() {
        return this.delegate;
    }

    public boolean contains(String propertyName) {
        return this.getProperties().containsKey(propertyName);
    }

    public boolean isEmpty() {
        return this.getProperties().isEmpty();
    }

    public boolean isSet(String propertyName) {
        return StringUtils.hasText(this.get(propertyName));
    }

    public boolean isUnset(String propertyName) {
        return this.contains(propertyName) && !this.isSet(propertyName);
    }

    protected <T> T convert(String propertyName, Class<T> type) {
        return this.getConversionService().convert(this.get(propertyName), type);
    }

    protected <T> T defaultIfNotSet(String propertyName, T defaultValue, Class<T> type) {
        return this.isSet(propertyName) ? this.convert(propertyName, type) : defaultValue;
    }

    protected String valueOf(String value) {
        return "null".equalsIgnoreCase(String.valueOf(value).trim()) ? null : value;
    }

    public PropertiesAdapter filter(Filter<String> filter) {
        Properties properties = new Properties();
        for (String propertyName : this) {
            if (!filter.accept(propertyName)) continue;
            properties.setProperty(propertyName, this.get(propertyName));
        }
        return PropertiesAdapter.from(properties);
    }

    public String get(String propertyName) {
        return this.get(propertyName, null);
    }

    public String get(String propertyName, String defaultValue) {
        return this.valueOf(this.getProperties().getProperty(propertyName, defaultValue));
    }

    public <T> T getAsType(String propertyName, Class<T> type) {
        return this.getAsType(propertyName, type, null);
    }

    public <T> T getAsType(String propertyName, Class<T> type, T defaultValue) {
        return this.defaultIfNotSet(propertyName, defaultValue, type);
    }

    @Override
    public Iterator<String> iterator() {
        return Collections.unmodifiableSet(this.getProperties().stringPropertyNames()).iterator();
    }

    public int size() {
        return this.getProperties().size();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PropertiesAdapter)) {
            return false;
        }
        PropertiesAdapter that = (PropertiesAdapter)obj;
        return this.getProperties().equals(that.getProperties());
    }

    public int hashCode() {
        int hashValue = 17;
        hashValue = 37 * hashValue + this.getProperties().hashCode();
        return hashValue;
    }

    public String toString() {
        return MapUtils.toString(this.toMap());
    }

    public Map<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>(this.size());
        for (String propertyName : this) {
            map.put(propertyName, this.get(propertyName));
        }
        return map;
    }
}

