/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import java.util.Properties;
import org.cp.elements.io.NoSuchFileException;
import org.cp.elements.lang.Builder;
import org.cp.elements.util.PropertiesAdapter;
import org.cp.elements.util.SystemException;

public class PropertiesBuilder
implements Builder<Properties> {
    private final Properties properties = new Properties();

    public static PropertiesBuilder from(File properties) {
        try {
            return PropertiesBuilder.from(new FileInputStream(properties));
        }
        catch (FileNotFoundException e) {
            throw new NoSuchFileException(String.format("[%1$s] not found", properties), e);
        }
    }

    public static PropertiesBuilder from(InputStream inputStream) {
        try {
            Properties defaults = new Properties();
            defaults.load(inputStream);
            return PropertiesBuilder.from(defaults);
        }
        catch (IOException cause) {
            throw new SystemException(String.format("Failed to load properties from input stream [%s]", inputStream), cause);
        }
    }

    public static PropertiesBuilder from(Map<String, ?> map) {
        Properties properties = new Properties();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            properties.setProperty(entry.getKey(), String.valueOf(entry.getValue()));
        }
        return PropertiesBuilder.from(properties);
    }

    public static PropertiesBuilder from(Properties properties) {
        return new PropertiesBuilder(properties);
    }

    public static PropertiesBuilder from(Reader reader) {
        try {
            Properties defaults = new Properties();
            defaults.load(reader);
            return PropertiesBuilder.from(defaults);
        }
        catch (IOException cause) {
            throw new SystemException(String.format("Failed to load properties from reader [%s]", reader), cause);
        }
    }

    public static PropertiesBuilder fromEnvironmentVariables() {
        return PropertiesBuilder.from(System.getenv());
    }

    public static PropertiesBuilder fromSystemProperties() {
        return PropertiesBuilder.from(System.getProperties());
    }

    public static PropertiesBuilder fromXml(InputStream inputStream) {
        try {
            Properties defaults = new Properties();
            defaults.loadFromXML(inputStream);
            return PropertiesBuilder.from(defaults);
        }
        catch (IOException cause) {
            throw new SystemException(String.format("Failed to load properties from input stream [%s]", inputStream), cause);
        }
    }

    public static PropertiesBuilder newInstance() {
        return new PropertiesBuilder();
    }

    public PropertiesBuilder() {
    }

    public PropertiesBuilder(Properties defaults) {
        this.properties.putAll((Map<?, ?>)defaults);
    }

    protected Properties getProperties() {
        return this.properties;
    }

    public PropertiesBuilder set(String propertyName, Object propertyValue) {
        return this.set(propertyName, String.valueOf(propertyValue));
    }

    public PropertiesBuilder set(String propertyName, String propertyValue) {
        this.getProperties().setProperty(propertyName, propertyValue);
        return this;
    }

    @Override
    public Properties build() {
        return this.getProperties();
    }

    public PropertiesAdapter buildPropertiesAdapter() {
        return PropertiesAdapter.from(this.build());
    }

    public String toString() {
        return this.getProperties().toString();
    }
}

