/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.util;

import java.util.Properties;
import org.cp.elements.lang.Assert;
import org.cp.elements.lang.FluentApiExtension;
import org.cp.elements.lang.annotation.FluentApi;

public abstract class PropertiesSetter
implements FluentApiExtension {
    private Properties properties;
    private final String propertyName;

    @FluentApi
    public static PropertiesSetter set(String propertyName) {
        return new PropertiesSetter(propertyName){};
    }

    protected PropertiesSetter(String propertyName) {
        Assert.hasText(propertyName, "Property name must be specified", new Object[0]);
        this.propertyName = propertyName;
    }

    protected Properties getProperties() {
        Assert.state(this.properties != null, "Properties were not specified", new Object[0]);
        return this.properties;
    }

    protected String getPropertyName() {
        return this.propertyName;
    }

    public PropertiesSetter of(Properties properties) {
        Assert.notNull(properties, "Properties cannot be null", new Object[0]);
        this.properties = properties;
        return this;
    }

    public void to(String propertyValue) {
        this.getProperties().setProperty(this.getPropertyName(), propertyValue);
    }

    public void with(Properties source) {
        Assert.notNull(source, "Source properties cannot be null", new Object[0]);
        String propertyName = this.getPropertyName();
        this.getProperties().setProperty(propertyName, source.getProperty(propertyName));
    }
}

