/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.util.paging;

import java.util.Comparator;
import java.util.stream.StreamSupport;
import org.cp.elements.lang.Assert;
import org.cp.elements.lang.ElementsExceptionsFactory;
import org.cp.elements.util.paging.Page;

public interface Pageable<T>
extends Iterable<Page<T>> {
    default public int count() {
        return (int)StreamSupport.stream(this.spliterator(), false).count();
    }

    default public Page<T> firstPage() {
        try {
            return this.getPage(1);
        }
        catch (Exception cause) {
            throw ElementsExceptionsFactory.newPageNotFoundException(cause, "No more pages", new Object[0]);
        }
    }

    default public Page<T> getPage(int number) {
        Assert.isTrue(number > 0, "Page number [%d] must be greater than 0", number);
        int count = 0;
        for (Page page : this) {
            if (++count != number) continue;
            return page;
        }
        throw ElementsExceptionsFactory.newPageNotFoundException("Page with number [%d] not found", number);
    }

    default public Page<T> lastPage() {
        try {
            return this.getPage(this.count());
        }
        catch (Exception cause) {
            throw ElementsExceptionsFactory.newPageNotFoundException(cause, "No more pages", new Object[0]);
        }
    }

    public void sort(Comparator<T> var1);
}

