/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.util.search;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cp.elements.lang.Assert;
import org.cp.elements.lang.ClassUtils;
import org.cp.elements.lang.ObjectUtils;
import org.cp.elements.util.search.Matcher;
import org.cp.elements.util.search.SearchException;
import org.cp.elements.util.search.Searcher;
import org.cp.elements.util.search.annotation.Searchable;

public abstract class AbstractSearcher
implements Searcher {
    protected static final boolean DEFAULT_CUSTOM_MATCHER_ALLOWED = true;
    private boolean customMatcherAllowed = true;
    private Matcher matcher;

    public boolean isCustomMatcherAllowed() {
        return this.customMatcherAllowed;
    }

    public void setCustomMatcherAllowed(boolean customMatcherAllowed) {
        this.customMatcherAllowed = customMatcherAllowed;
    }

    @Override
    public <E> Matcher<E> getMatcher() {
        Matcher<?> localMatcher = MatcherHolder.get();
        Assert.state(localMatcher != null || this.matcher != null, "A reference to a Matcher used by this Searcher ({0}) for searching and matching elements in the collection was not properly configured!", this.getClass().getName());
        return ObjectUtils.defaultIfNull(localMatcher, this.matcher);
    }

    public void setMatcher(Matcher matcher) {
        Assert.notNull(matcher, "The Matcher used to match elements in the collection during the search operation by this Searcher ({0}) cannot be null!", this.getClass().getName());
        this.matcher = matcher;
    }

    @Override
    public <E> E search(E ... array) {
        return this.search(Arrays.asList(array));
    }

    @Override
    public <E> E search(org.cp.elements.util.search.Searchable<E> searchable) {
        try {
            E e = this.search(this.configureMatcher(searchable).asList());
            return e;
        }
        finally {
            MatcherHolder.unset();
        }
    }

    @Override
    public <E> E search(Object searchableAnnotatedObject) {
        try {
            E e = this.search(this.asList(searchableAnnotatedObject, this.configureMatcher(this.getSearchableMetaData(searchableAnnotatedObject))));
            return e;
        }
        finally {
            MatcherHolder.unset();
        }
    }

    @Override
    public <E> Iterable<E> searchForAll(E ... array) {
        return this.searchForAll(Arrays.asList(array));
    }

    @Override
    public <E> Iterable<E> searchForAll(Collection<E> collection) {
        Assert.notNull(collection, "The collection to search cannot be null!", new Object[0]);
        ArrayList<E> results = new ArrayList<E>(collection.size());
        for (E element : collection) {
            if (!this.getMatcher().isMatch(element)) continue;
            results.add(element);
        }
        return results;
    }

    @Override
    public <E> Iterable<E> searchForAll(org.cp.elements.util.search.Searchable<E> searchable) {
        try {
            Iterable<E> iterable = this.searchForAll(this.configureMatcher(searchable).asList());
            return iterable;
        }
        finally {
            MatcherHolder.unset();
        }
    }

    @Override
    public <E> Iterable<E> searchForAll(Object searchableAnnotatedObject) {
        try {
            Iterable<E> iterable = this.searchForAll(this.asList(searchableAnnotatedObject, this.configureMatcher(this.getSearchableMetaData(searchableAnnotatedObject))));
            return iterable;
        }
        finally {
            MatcherHolder.unset();
        }
    }

    protected Searchable getSearchableMetaData(Object obj) {
        Assert.notNull(obj, "The object to search cannot be null!", new Object[0]);
        Searchable searchableAnnotation = obj.getClass().getAnnotation(Searchable.class);
        Assert.notNull(searchableAnnotation, new SearchException(String.format("To search an object of type (%1$s), the class must be annotated with the (%2$s) annotation!", obj.getClass().getName(), Searchable.class.getName())));
        return searchableAnnotation;
    }

    protected <T> org.cp.elements.util.search.Searchable<T> configureMatcher(org.cp.elements.util.search.Searchable<T> searchable) {
        Matcher<T> matcher;
        if (this.isCustomMatcherAllowed() && (matcher = searchable.getMatcher()) != null) {
            MatcherHolder.set(matcher);
        }
        return searchable;
    }

    protected Searchable configureMatcher(Searchable searchableAnnotation) {
        try {
            Class<? extends Matcher> matcherClass;
            if (this.isCustomMatcherAllowed() && !Matcher.class.equals(matcherClass = searchableAnnotation.matcher())) {
                MatcherHolder.set(matcherClass.newInstance());
            }
            return searchableAnnotation;
        }
        catch (Exception e) {
            throw new SearchException(String.format("Error occurred creating an instance of Matcher class (%1$s) to be used by this Searcher (%2$s)! The Matcher class (%1$s) must have a public no-arg constructor!", searchableAnnotation.matcher().getName(), this.getClass().getName()), e);
        }
    }

    protected <E> List<E> asList(Object obj, Searchable searchableAnnotation) {
        try {
            Method listMethod = ClassUtils.getMethod(obj.getClass(), searchableAnnotation.listMethod(), new Class[0]);
            List collection = (List)listMethod.invoke(obj, new Object[0]);
            return ObjectUtils.defaultIfNull(collection, Collections.emptyList());
        }
        catch (Exception e) {
            throw new SearchException(String.format("Error occurred getting the list of elements to search from the (%1$s) method on object of type (%2$s)!", searchableAnnotation.listMethod(), obj.getClass().getName()), e);
        }
    }

    protected static class MatcherHolder {
        private static final ThreadLocal<Matcher<?>> MATCHER_HOLDER = new ThreadLocal();

        protected MatcherHolder() {
        }

        public static Matcher<?> get() {
            return MATCHER_HOLDER.get();
        }

        public static boolean isSet() {
            return MatcherHolder.get() != null;
        }

        public static void set(Matcher<?> matcher) {
            MATCHER_HOLDER.set(matcher);
        }

        public static void unset() {
            MATCHER_HOLDER.remove();
        }
    }
}

