/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.util.search;

public enum SearchType {
    BINARY_SEARCH("BINARY", "Binary Search"),
    INDEX_SEARCH("INDEX", "Index Search"),
    LINEAR_SEARCH("LINEAR", "Linear Search"),
    UNKNOWN_SEARCH("UNKNOWN", "Unknown Search");

    private final String abbreviation;
    private final String name;

    private SearchType(String abbreviation, String name) {
        this.abbreviation = abbreviation;
        this.name = name;
    }

    public static SearchType valueOfAbbreviation(String abbreviation) {
        for (SearchType value : SearchType.values()) {
            if (!value.getAbbreviation().equalsIgnoreCase(abbreviation)) continue;
            return value;
        }
        return null;
    }

    public static SearchType valueOfName(String name) {
        for (SearchType value : SearchType.values()) {
            if (!value.getName().equalsIgnoreCase(name)) continue;
            return value;
        }
        return null;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

