/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.util.search;

import org.cp.elements.lang.ObjectUtils;
import org.cp.elements.util.search.SearchType;
import org.cp.elements.util.search.Searcher;
import org.cp.elements.util.search.support.BinarySearch;
import org.cp.elements.util.search.support.LinearSearch;

public class SearcherFactory {
    public static <T extends Searcher> T createSearcher(SearchType type) {
        switch (ObjectUtils.defaultIfNull(type, SearchType.UNKNOWN_SEARCH)) {
            case BINARY_SEARCH: {
                return (T)new BinarySearch();
            }
            case LINEAR_SEARCH: {
                return (T)new LinearSearch();
            }
        }
        throw new IllegalArgumentException(String.format("The SearchType (%1$s) is not supported by the %2$s!", new Object[]{type, SearcherFactory.class.getSimpleName()}));
    }

    public static <T extends Searcher> T createSearcherElseDefault(SearchType type, T defaultSearcher) {
        try {
            return SearcherFactory.createSearcher(type);
        }
        catch (IllegalArgumentException ignore) {
            return defaultSearcher;
        }
    }
}

