/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.util.search.support;

import java.util.Collection;
import java.util.List;
import org.cp.elements.lang.Assert;
import org.cp.elements.lang.ClassUtils;
import org.cp.elements.util.search.AbstractSearcher;

public class BinarySearch
extends AbstractSearcher {
    @Override
    public <E> E search(Collection<E> collection) {
        Assert.isInstanceOf(collection, List.class, "The collection {0} must be an instance of java.util.List!", ClassUtils.getClassName(collection));
        return this.doSearch((List)collection);
    }

    protected <E> E doSearch(List<E> list) {
        if (!list.isEmpty()) {
            int matchIndex = list.size() / 2;
            E element = list.get(matchIndex);
            int matchResult = this.getMatcher().match(element);
            if (matchResult == 0) {
                return element;
            }
            if (matchResult < 0) {
                return this.doSearch(list.subList(0, matchIndex));
            }
            return this.doSearch(list.subList(matchIndex + 1, list.size()));
        }
        return null;
    }
}

