/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.util.sort;

import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.cp.elements.lang.Assert;
import org.cp.elements.lang.ObjectUtils;
import org.cp.elements.util.sort.SortException;
import org.cp.elements.util.sort.Sortable;
import org.cp.elements.util.sort.Sorter;

public abstract class AbstractSorter
implements Sorter {
    protected static final boolean DEFAULT_CUSTOM_COMPARATOR_ALLOWED = true;
    private boolean customComparatorAllowed = true;
    private Comparator orderBy;

    public boolean isCustomComparatorAllowed() {
        return this.customComparatorAllowed;
    }

    public void setCustomComparatorAllowed(boolean customComparatorAllowed) {
        this.customComparatorAllowed = customComparatorAllowed;
    }

    @Override
    public <E> Comparator<E> getOrderBy() {
        return ObjectUtils.defaultIfNull(ComparatorHolder.get(), ObjectUtils.defaultIfNull(this.orderBy, ComparableComparator.INSTANCE));
    }

    public void setOrderBy(Comparator orderBy) {
        this.orderBy = orderBy;
    }

    @Override
    public <E> E[] sort(E ... elements) {
        this.sort((T)new SortableArrayList<E>(elements));
        return elements;
    }

    @Override
    public <E> Sortable<E> sort(Sortable<E> sortable) {
        try {
            this.sort((T)this.configureComparator(sortable).asList());
            Sortable<E> sortable2 = sortable;
            return sortable2;
        }
        finally {
            ComparatorHolder.unset();
        }
    }

    @Override
    public <T> T sort(T sortableAnnotatedObject) {
        try {
            this.sort((T)this.asList(sortableAnnotatedObject, this.configureComparator(this.getSortableMetaData(sortableAnnotatedObject))));
            T t = sortableAnnotatedObject;
            return t;
        }
        finally {
            ComparatorHolder.unset();
        }
    }

    protected org.cp.elements.util.sort.annotation.Sortable getSortableMetaData(Object sortableAnnotatedObject) {
        Assert.notNull(sortableAnnotatedObject, "The @Sortable annotated object cannot be null!", new Object[0]);
        org.cp.elements.util.sort.annotation.Sortable sortableMetaData = sortableAnnotatedObject.getClass().getAnnotation(org.cp.elements.util.sort.annotation.Sortable.class);
        Assert.notNull(sortableMetaData, new SortException(String.format("To sort an object of type (%1$s), the class must be annotated with the (%2$s) annotation!", sortableAnnotatedObject.getClass().getName(), org.cp.elements.util.sort.annotation.Sortable.class.getName())));
        return sortableMetaData;
    }

    protected <T> Sortable<T> configureComparator(Sortable<T> sortable) {
        Comparator<T> comparator;
        if (this.isCustomComparatorAllowed() && (comparator = sortable.getOrderBy()) != null) {
            ComparatorHolder.set(comparator);
        }
        return sortable;
    }

    protected org.cp.elements.util.sort.annotation.Sortable configureComparator(org.cp.elements.util.sort.annotation.Sortable sortableMetaData) {
        try {
            Class<? extends Comparator> comparatorClass;
            if (this.isCustomComparatorAllowed() && !Comparator.class.equals(comparatorClass = sortableMetaData.orderBy())) {
                ComparatorHolder.set(comparatorClass.newInstance());
            }
            return sortableMetaData;
        }
        catch (Exception e) {
            throw new SortException(String.format("Error occurred creating an instance of Comparator class (%1$s) to be used by this Sorter (%2$s)! The Comparator class (%1$s) must have a public no-arg constructor!", sortableMetaData.orderBy().getName(), this.getClass().getName()), e);
        }
    }

    protected <E> List<E> asList(Object obj, org.cp.elements.util.sort.annotation.Sortable sortableMetaData) {
        try {
            Method asList = obj.getClass().getMethod(sortableMetaData.listMethod(), new Class[0]);
            List list = (List)asList.invoke(obj, new Object[0]);
            return ObjectUtils.defaultIfNull(list, Collections.emptyList());
        }
        catch (Exception e) {
            throw new SortException(String.format("Error occurred getting the list of elements to sort from the (%1$s) method on object of type (%2$s)!", sortableMetaData.listMethod(), obj.getClass().getName()), e);
        }
    }

    protected <E> void swap(List<E> elements, int index1, int index2) {
        E elementFromIndex1 = elements.get(index1);
        elements.set(index1, elements.get(index2));
        elements.set(index2, elementFromIndex1);
    }

    protected static class SortableArrayList<E>
    extends AbstractList<E> {
        private final E[] elements;

        @SafeVarargs
        public SortableArrayList(E ... elements) {
            Assert.notNull(elements, "The array of elements to wrap in a List cannot be null!", new Object[0]);
            this.elements = elements;
        }

        @Override
        public E get(int index) {
            return this.elements[index];
        }

        @Override
        public E set(int index, E element) {
            E previousElement = this.elements[index];
            this.elements[index] = element;
            return previousElement;
        }

        @Override
        public int size() {
            return this.elements.length;
        }
    }

    protected static class ComparatorHolder {
        private static final ThreadLocal<Comparator<?>> COMPARATOR_HOLDER = new ThreadLocal();

        protected ComparatorHolder() {
        }

        public static Comparator<?> get() {
            return COMPARATOR_HOLDER.get();
        }

        public static boolean isSet() {
            return ComparatorHolder.get() != null;
        }

        public static void set(Comparator<?> comparator) {
            COMPARATOR_HOLDER.set(comparator);
        }

        public static void unset() {
            COMPARATOR_HOLDER.remove();
        }
    }

    protected static class ComparableComparator<T extends Comparable<T>>
    implements Comparator<T> {
        protected static final ComparableComparator INSTANCE = new ComparableComparator();

        protected ComparableComparator() {
        }

        @Override
        public int compare(T comparable1, T comparable2) {
            return comparable1.compareTo(comparable2);
        }
    }
}

