/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.util.sort;

public enum SortType {
    BUBBLE_SORT("BUBBLE", "Bubble Sort"),
    COMB_SORT("COMB", "Comb Sort"),
    HEAP_SORT("HEAP", "Heap Sort"),
    INSERTION_SORT("INSERTION", "Insertion Sort"),
    MERGE_SORT("MERGE", "Merge Sort"),
    QUICK_SORT("QUICK", "Quick Sort"),
    SELECTION_SORT("SELECTION", "Selection Sort"),
    SHELL_SORT("SHELL", "Shell Sort"),
    UNKONWN("UNKNOWN", "Unknown Sort");

    private final String abbreviation;
    private final String name;

    private SortType(String abbreviation, String name) {
        this.abbreviation = abbreviation;
        this.name = name;
    }

    public static SortType valueOfAbbreviation(String abbreviation) {
        for (SortType value : SortType.values()) {
            if (!value.getAbbreviation().equalsIgnoreCase(abbreviation)) continue;
            return value;
        }
        return null;
    }

    public static SortType valueOfName(String name) {
        for (SortType value : SortType.values()) {
            if (!value.getName().equalsIgnoreCase(name)) continue;
            return value;
        }
        return null;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

