/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.util.sort;

import org.cp.elements.lang.ObjectUtils;
import org.cp.elements.util.sort.SortType;
import org.cp.elements.util.sort.Sorter;
import org.cp.elements.util.sort.support.BubbleSort;
import org.cp.elements.util.sort.support.CombSort;
import org.cp.elements.util.sort.support.HeapSort;
import org.cp.elements.util.sort.support.InsertionSort;
import org.cp.elements.util.sort.support.MergeSort;
import org.cp.elements.util.sort.support.QuickSort;
import org.cp.elements.util.sort.support.SelectionSort;
import org.cp.elements.util.sort.support.ShellSort;

public class SorterFactory {
    public static <T extends Sorter> T createSorter(SortType type) {
        switch (ObjectUtils.defaultIfNull(type, SortType.UNKONWN)) {
            case BUBBLE_SORT: {
                return (T)new BubbleSort();
            }
            case COMB_SORT: {
                return (T)new CombSort();
            }
            case HEAP_SORT: {
                return (T)new HeapSort();
            }
            case INSERTION_SORT: {
                return (T)new InsertionSort();
            }
            case MERGE_SORT: {
                return (T)new MergeSort();
            }
            case QUICK_SORT: {
                return (T)new QuickSort();
            }
            case SELECTION_SORT: {
                return (T)new SelectionSort();
            }
            case SHELL_SORT: {
                return (T)new ShellSort();
            }
        }
        throw new IllegalArgumentException(String.format("The SortType (%1$s) is not supported by the %2$s!", new Object[]{type, SorterFactory.class.getSimpleName()}));
    }

    public static <T extends Sorter> T createSorterElseDefault(SortType type, T defaultSorter) {
        try {
            return SorterFactory.createSorter(type);
        }
        catch (IllegalArgumentException ignore) {
            return defaultSorter;
        }
    }
}

