/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.util.sort.support;

import java.util.List;
import org.cp.elements.util.sort.AbstractSorter;

public class HeapSort
extends AbstractSorter {
    @Override
    public <E> List<E> sort(List<E> elements) {
        int size = elements.size();
        for (int parentIndex = (size - 2) / 2; parentIndex >= 0; --parentIndex) {
            this.siftDown(elements, parentIndex, size - 1);
        }
        for (int count = size - 1; count > 0; --count) {
            this.swap(elements, 0, count);
            this.siftDown(elements, 0, count - 1);
        }
        return elements;
    }

    protected <E> void siftDown(List<E> elements, int startIndex, int endIndex) {
        int rootIndex = startIndex;
        while (rootIndex * 2 + 1 <= endIndex) {
            int swapIndex = rootIndex;
            int leftChildIndex = rootIndex * 2 + 1;
            int rightChildIndex = leftChildIndex + 1;
            if (this.getOrderBy().compare(elements.get(swapIndex), elements.get(leftChildIndex)) < 0) {
                swapIndex = leftChildIndex;
            }
            if (rightChildIndex <= endIndex && this.getOrderBy().compare(elements.get(swapIndex), elements.get(rightChildIndex)) < 0) {
                swapIndex = rightChildIndex;
            }
            if (swapIndex != rootIndex) {
                this.swap(elements, rootIndex, swapIndex);
                rootIndex = swapIndex;
                continue;
            }
            return;
        }
    }
}

