/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.util.sort.support;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.cp.elements.util.sort.AbstractSorter;

public class MergeSort
extends AbstractSorter {
    @Override
    public <E> E[] sort(E ... elements) {
        return this.sort(new AbstractSorter.SortableArrayList<E>(elements)).toArray((Object[])Array.newInstance(elements.getClass().getComponentType(), elements.length));
    }

    @Override
    public <E> List<E> sort(List<E> elements) {
        if (elements.size() > 1) {
            int size = elements.size();
            int count = size / 2 + size % 2;
            List<E> leftElements = this.sort(elements.subList(0, count));
            List<E> rightElements = this.sort(elements.subList(count, size));
            return this.merge(leftElements, rightElements);
        }
        return elements;
    }

    protected <E> List<E> merge(List<E> leftElements, List<E> rightElements) {
        int leftIndex = 0;
        int leftSize = leftElements.size();
        int rightIndex = 0;
        int rightSize = rightElements.size();
        ArrayList<E> mergedElements = new ArrayList<E>(leftSize + rightSize);
        int mergeSize = leftSize + rightSize;
        for (int mergeIndex = 0; mergeIndex < mergeSize; ++mergeIndex) {
            if (leftIndex == leftSize) {
                mergedElements.add(rightElements.get(rightIndex++));
                continue;
            }
            if (rightIndex == rightSize) {
                mergedElements.add(leftElements.get(leftIndex++));
                continue;
            }
            E leftElement = leftElements.get(leftIndex);
            E rightElement = rightElements.get(rightIndex);
            if (this.getOrderBy().compare(leftElement, rightElement) <= 0) {
                mergedElements.add(leftElement);
                ++leftIndex;
                continue;
            }
            mergedElements.add(rightElement);
            ++rightIndex;
        }
        return mergedElements;
    }
}

